/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.javametrics.web;

import com.ibm.javametrics.web.DataHandler;
import com.ibm.javametrics.web.Emitter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

@ServerEndpoint(value="/javametrics-socket", subprotocols={"/"})
public class JavametricsWebSocket
implements Emitter {
    private Set<Session> openSessions = new HashSet();

    @OnOpen
    public void open(Session session) {
        try {
            session.getBasicRemote().sendText("{\"topic\": \"title\", \"payload\": {\"title\":\"Application Metrics for Java\", \"docs\": \"http://github.com/RuntimeTools/javametrics\"}}");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.openSessions.add(session);
        DataHandler.registerEmitter((Emitter)this);
    }

    @OnClose
    public void close(Session session) {
        DataHandler.deregisterEmitter((Emitter)this);
        this.openSessions.remove(session);
    }

    @OnError
    public void onError(Throwable error) {
    }

    @OnMessage
    public void handleMessage(String message, Session session) {
    }

    public void emit(String message) {
        this.openSessions.forEach(session -> {
            try {
                if (session.isOpen()) {
                    session.getBasicRemote().sendText(message);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

