/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.javametrics.codewind.web;

import com.ibm.javametrics.client.HttpDataAggregator;
import com.ibm.javametrics.codewind.web.DataHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebPage
extends HttpServlet {
    private static final long serialVersionUID = -4751096228274971485L;
    private DataHandler dataHandler = DataHandler.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest reqest, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Cache-Control", "private, no-store, no-cache, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("text/plain");
        PrintWriter write = response.getWriter();
        write.println("# HELP os_cpu_used_ratio The ratio of the systems CPU that is currently used (values are 0-1)\n");
        write.println("# TYPE os_cpu_used_ratio gauge\n");
        write.println("os_cpu_used_ratio " + this.dataHandler.getLatestCPUEventSystem() + "\n");
        write.println("# HELP process_cpu_used_ratio The ratio of the systems CPU that is currently being used by the monitored process (values are 0-1)\n");
        write.println("# TYPE process_cpu_used_ratio gauge\n");
        write.println("process_cpu_used_ratio " + this.dataHandler.getLatestCPUEventProcess() + "\n");
        write.println("# HELP os_cpu_used_ratio_average The average ratio of the systems CPU used since monitoring began (values are 0-1)\n");
        write.println("# TYPE os_cpu_used_ratio_average gauge\n");
        write.println("os_cpu_used_ratio_average " + this.dataHandler.getLatestCPUEventSystemMean() + "\n");
        write.println("# HELP process_cpu_used_ratio_average The average ratio of the systems CPU used by the monitored process since monitoring began (values are 0-1)\n");
        write.println("# TYPE process_cpu_used_ratio_average gauge\n");
        write.println("process_cpu_used_ratio_average " + this.dataHandler.getLatestCPUEventProcessMean() + "\n");
        write.println("# HELP process_native_memory_used_bytes The amount of native memory the monitored process is currently using (in bytes)\n");
        write.println("# TYPE process_native_memory_used_bytes gauge\n");
        write.println("process_native_memory_used_bytes " + this.dataHandler.getLatestMemEventUsedNative() + "\n");
        write.println("# HELP process_native_memory_used_max_bytes The greatest amount of native memory used by the monitored process since monitoring began (in bytes)\n");
        write.println("# TYPE process_native_memory_used_max_bytes gauge\n");
        write.println("process_native_memory_used_max_bytes " + this.dataHandler.getLatestMemEventUsedNativeMax() + "\n");
        write.println("# HELP process_heap_memory_used_bytes The amount of memory the monitored process's heap is currently using (in bytes)\n");
        write.println("# TYPE process_heap_memory_used_bytes gauge\n");
        write.println("process_heap_memory_used_bytes " + this.dataHandler.getLatestMemEventUsedHeap() + "\n");
        write.println("# HELP process_heap_memory_used_after_GC_bytes The amount of memory the monitored process's heap was using after the last garbage collection (in bytes)\n");
        write.println("# TYPE process_heap_memory_used_after_GC_bytes gauge\n");
        write.println("process_heap_memory_used_after_GC_bytes " + this.dataHandler.getLatestMemEventUsedHeapAfterGC() + "\n");
        write.println("# HELP process_heap_memory_used_after_GC_max_bytes The maximum amount of memory the monitored process's heap was using after a garbage collection since monitoring began (in bytes)\n");
        write.println("# TYPE process_heap_memory_used_after_GC_max_bytes gauge\n");
        write.println("process_heap_memory_used_after_GC_max_bytes " + this.dataHandler.getLatestMemEventUsedHeapAfterGCMax() + "\n");
        write.println("# HELP environment_variable a key-value pair stored in the property of the metric. Counter is always 1.\n");
        write.println("# TYPE environment_variable counter\n");
        for (Map.Entry<String, String> entry : this.dataHandler.getLatestEnvMap().entrySet()) {
            write.println("environment_variable{" + entry.getKey().replaceAll(" ", "") + "=\"" + entry.getValue() + "\"} 1\n");
        }
        write.println("# HELP time_in_gc_percentage The current amount of time spent performing garbage collection as a percentage of the current runtime of the application \n");
        write.println("# TYPE time_in_gc_percentage gauge\n");
        write.println("time_in_gc_percentage " + this.dataHandler.getLatestGCEventGCTime() + "\n");
        write.println("# HELP overall_time_in_gc_percentage The overall amount of time spent performing garbage collection as a percentage of the overall runtime of the application \n");
        write.println("# TYPE overall_time_in_gc_percentage gauge\n");
        write.println("overall_time_in_gc_percentage " + this.dataHandler.getLatestGCEventGCTimeSummary() + "\n");
        HttpDataAggregator httpDataAggregator = this.dataHandler.getAggregateHttpData();
        synchronized (httpDataAggregator) {
            write.println("# HELP http_requests_total Total number of HTTP requests received in this snapshot.\n");
            write.println("# TYPE http_requests_total gauge\n");
            write.println("http_requests_total " + this.dataHandler.getAggregateHttpData().getTotalHits() + "\n");
            write.println("# HELP http_requests_duration_average_microseconds Average duration of HTTP requests received in this snapshot.\n");
            write.println("# TYPE http_requests_duration_average_microseconds gauge\n");
            write.println("http_requests_duration_average_microseconds " + this.dataHandler.getAggregateHttpData().getAverage() + "\n");
            write.println("# HELP http_requests_duration_max_microseconds Longest HTTP request received in this snapshot.\n");
            write.println("# TYPE http_requests_duration_max_microseconds gauge\n");
            write.println("http_requests_duration_max_microseconds{handler=\"" + this.dataHandler.getAggregateHttpData().getLongestUrl() + "\",method=\"" + this.dataHandler.getAggregateHttpData().getLongestMethod() + "\"} " + this.dataHandler.getAggregateHttpData().getLongest() + "\n");
            write.println("# HELP http_request_duration_max_microseconds The maximum HTTP request latencies in microseconds.\n");
            write.println("# TYPE http_request_duration_max_microseconds gauge\n");
            for (HttpDataAggregator.HttpUrlData hud : this.dataHandler.getAggregateHttpData().getUrlData()) {
                write.println("http_request_duration_max_microseconds{handler=\"" + hud.getUrl() + "\",method=\"" + hud.getMethod() + "\"} " + hud.getLongestResponseTime() + "\n");
            }
            write.println("# HELP http_request_duration_avg_microseconds The average HTTP request latencies in microseconds.\n");
            write.println("# TYPE http_request_duration_avg_microseconds gauge\n");
            for (HttpDataAggregator.HttpUrlData hud : this.dataHandler.getAggregateHttpData().getUrlData()) {
                write.println("http_request_duration_avg_microseconds{handler=\"" + hud.getUrl() + "\",method=\"" + hud.getMethod() + "\"} " + hud.getAverageResponseTime() + "\n");
            }
            write.println("# HELP http_request_total Total number of HTTP requests made for that URL.\n");
            write.println("# TYPE http_request_total counter\n");
            for (HttpDataAggregator.HttpUrlData hud : this.dataHandler.getAggregateHttpData().getUrlData()) {
                write.println("http_request_total{handler=\"" + hud.getUrl() + "\",method=\"" + hud.getMethod() + "\"} " + hud.getHits() + "\n");
            }
            this.dataHandler.getAggregateHttpData().resetSummaryData();
        }
    }

    public void init() throws ServletException {
        System.out.println("Servlet " + this.getServletName() + " has started");
    }

    public void destroy() {
        System.out.println("Servlet " + this.getServletName() + " has stopped");
    }
}

