/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.javametrics.codewind.web;

import com.ibm.javametrics.Javametrics;
import com.ibm.javametrics.JavametricsListener;
import com.ibm.javametrics.client.ApiDataListener;
import com.ibm.javametrics.client.HttpDataAggregator;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class DataHandler
extends ApiDataListener {
    private static DataHandler instance = null;
    private double latestCPUEventProcess = 0.0;
    private double latestCPUEventSystem = 0.0;
    private double latestCPUEventProcessMean = 0.0;
    private double latestCPUEventSystemMean = 0.0;
    private long latestMemEventUsedHeapAfterGC = 0L;
    private long latestMemEventUsedHeapAfterGCMax = 0L;
    private long latestMemEventUsedHeap = 0L;
    private long latestMemEventUsedNative = 0L;
    private long latestMemEventUsedNativeMax = 0L;
    private double latestGCEventGCTime = 0.0;
    private double latestGCEventGCTimeSummary = 0.0;
    private HashMap<String, String> latestEnvMap = new HashMap();
    private HttpDataAggregator aggregateHttpData = new HttpDataAggregator();

    protected static DataHandler getInstance() {
        if (instance == null) {
            instance = new DataHandler();
            Javametrics.getInstance().addListener((JavametricsListener)instance);
        }
        return instance;
    }

    protected DataHandler() {
    }

    protected void finalize() {
        Javametrics.getInstance().removeListener((JavametricsListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processData(List<String> jsonData) {
        block19: for (String jsonStr : jsonData) {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonStr));
            try {
                JsonObject jsonObject = jsonReader.readObject();
                String topicName = jsonObject.getString("topic", null);
                if (topicName == null) continue;
                switch (topicName) {
                    case "http": {
                        JsonObject payload = jsonObject.getJsonObject("payload");
                        long requestTime = payload.getJsonNumber("time").longValue();
                        long requestDuration = payload.getJsonNumber("duration").longValue();
                        String requestUrl = payload.getString("url", "");
                        String requestMethod = payload.getString("method", "");
                        HttpDataAggregator httpDataAggregator = this.aggregateHttpData;
                        synchronized (httpDataAggregator) {
                            this.aggregateHttpData.aggregate(requestTime, requestDuration, requestUrl, requestMethod);
                            break;
                        }
                    }
                    case "cpu": {
                        JsonObject payload = jsonObject.getJsonObject("payload");
                        this.latestCPUEventProcess = payload.getJsonNumber("process").doubleValue();
                        this.latestCPUEventSystem = payload.getJsonNumber("system").doubleValue();
                        this.latestCPUEventProcessMean = payload.getJsonNumber("processMean").doubleValue();
                        this.latestCPUEventSystemMean = payload.getJsonNumber("systemMean").doubleValue();
                        break;
                    }
                    case "memoryPools": {
                        JsonObject payload = jsonObject.getJsonObject("payload");
                        this.latestMemEventUsedHeapAfterGC = payload.getJsonNumber("usedHeapAfterGC").longValue();
                        this.latestMemEventUsedHeapAfterGCMax = payload.getJsonNumber("usedHeapAfterGCMax").longValue();
                        this.latestMemEventUsedHeap = payload.getJsonNumber("usedHeap").longValue();
                        this.latestMemEventUsedNative = payload.getJsonNumber("usedNative").longValue();
                        this.latestMemEventUsedNativeMax = payload.getJsonNumber("usedNativeMax").longValue();
                        break;
                    }
                    case "gc": {
                        JsonObject payload = jsonObject.getJsonObject("payload");
                        this.latestGCEventGCTime = payload.getJsonNumber("gcTime").doubleValue();
                        this.latestGCEventGCTimeSummary = payload.getJsonNumber("gcTimeSummary").doubleValue();
                        break;
                    }
                    case "env": {
                        JsonArray envPayload = jsonObject.getJsonArray("payload");
                        for (int i = 0; i < envPayload.size(); ++i) {
                            JsonObject envar = envPayload.getJsonObject(i);
                            String param = envar.getJsonString("Parameter").getString();
                            String value = envar.getJsonString("Value").getString();
                            this.latestEnvMap.put(param, value);
                        }
                        continue block19;
                    }
                }
            }
            catch (JsonException je) {
                je.printStackTrace();
            }
        }
    }

    public double getLatestCPUEventProcess() {
        return this.latestCPUEventProcess;
    }

    public double getLatestCPUEventSystem() {
        return this.latestCPUEventSystem;
    }

    public double getLatestCPUEventProcessMean() {
        return this.latestCPUEventProcessMean;
    }

    public double getLatestCPUEventSystemMean() {
        return this.latestCPUEventSystemMean;
    }

    public long getLatestMemEventUsedHeapAfterGC() {
        return this.latestMemEventUsedHeapAfterGC;
    }

    public long getLatestMemEventUsedHeapAfterGCMax() {
        return this.latestMemEventUsedHeapAfterGCMax;
    }

    public long getLatestMemEventUsedHeap() {
        return this.latestMemEventUsedHeap;
    }

    public long getLatestMemEventUsedNative() {
        return this.latestMemEventUsedNative;
    }

    public long getLatestMemEventUsedNativeMax() {
        return this.latestMemEventUsedNativeMax;
    }

    public double getLatestGCEventGCTime() {
        return this.latestGCEventGCTime;
    }

    public double getLatestGCEventGCTimeSummary() {
        return this.latestGCEventGCTimeSummary;
    }

    public HashMap<String, String> getLatestEnvMap() {
        return this.latestEnvMap;
    }

    public HttpDataAggregator getAggregateHttpData() {
        return this.aggregateHttpData;
    }
}

