/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.spring.boot.MQConfigurationProperties;
import com.ibm.mq.spring.boot.MQConnectionFactoryCustomizer;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import javax.jms.JMSException;

class MQConnectionFactoryFactory {
    private final MQConfigurationProperties properties;
    private final List<MQConnectionFactoryCustomizer> factoryCustomizers;

    MQConnectionFactoryFactory(MQConfigurationProperties properties, List<MQConnectionFactoryCustomizer> factoryCustomizers) {
        this.properties = properties;
        this.factoryCustomizers = factoryCustomizers != null ? factoryCustomizers : Collections.emptyList();
    }

    public <T extends MQConnectionFactory> T createConnectionFactory(Class<T> factoryClass) {
        String err = null;
        try {
            T cf = this.createConnectionFactoryInstance(factoryClass);
            String qmName = this.properties.getQueueManager();
            cf.setStringProperty("XMSC_WMQ_QUEUE_MANAGER", qmName);
            String channel = this.properties.getChannel();
            String connName = this.properties.getConnName();
            if (this.isNullOrEmpty(channel) || this.isNullOrEmpty(connName)) {
                cf.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 0);
            } else {
                cf.setStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST", connName);
                cf.setStringProperty("XMSC_WMQ_CHANNEL", channel);
                cf.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 1);
            }
            String u = this.properties.getUser();
            if (!this.isNullOrEmpty(u)) {
                cf.setStringProperty("XMSC_USERID", u);
                cf.setStringProperty("XMSC_PASSWORD", this.properties.getPassword());
                cf.setBooleanProperty("XMSC_USER_AUTHENTICATION_MQCSP", true);
            }
            if (!this.isNullOrEmpty(this.properties.getSslCipherSuite())) {
                cf.setStringProperty("XMSC_WMQ_SSL_CIPHER_SUITE", this.properties.getSslCipherSuite());
            }
            if (!this.isNullOrEmpty(this.properties.getSslCipherSpec())) {
                cf.setStringProperty("XMSC_WMQ_SSL_CIPHER_SPEC", this.properties.getSslCipherSpec());
            }
            this.customize((MQConnectionFactory)cf);
            return cf;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | JMSException ex) {
            throw new IllegalStateException("Unable to create MQConnectionFactory" + (err != null ? ": " + err : ""), ex);
        }
    }

    private <T extends MQConnectionFactory> T createConnectionFactoryInstance(Class<T> factoryClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return (T)((MQConnectionFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    private void customize(MQConnectionFactory connectionFactory) {
        for (MQConnectionFactoryCustomizer factoryCustomizer : this.factoryCustomizers) {
            factoryCustomizer.customize(connectionFactory);
        }
    }

    boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

