/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mfp.java.token.validator.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.mfp.java.token.validator.TokenIntrospectionData;
import com.ibm.mfp.java.token.validator.TokenValidationException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class TokenValidationUtils {
    private static final String BEARER = "Bearer";
    private static ObjectMapper mapper;
    private static CloseableHttpClient httpClient;

    public static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        return mapper;
    }

    private static CloseableHttpClient buildHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makePostRequest(String path, Map<String, String> headers, List<BasicNameValuePair> formParams) throws TokenValidationException, IOException {
        if (httpClient == null) {
            try {
                httpClient = TokenValidationUtils.buildHttpClient();
            }
            catch (Exception e) {
                throw new TokenValidationException("Unable to create SSL HttpClient for sending requests to authorization server, reason : " + e.getLocalizedMessage(), e);
            }
        }
        HttpPost httpPost = new HttpPost(path);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            httpPost.setHeader(key, value);
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams));
        CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpPost);
        int status = resp.getStatusLine().getStatusCode();
        HttpEntity responseEntity = null;
        try {
            String body;
            responseEntity = resp.getEntity();
            String string = body = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity) : null;
            if (body == null || status != 200) {
                throw new TokenValidationException("Unsuccessful request to Authorization Server, server responded with status code: " + status + " and body : " + body + ", check the Authorization URL: " + path, status);
            }
            String string2 = body;
            return string2;
        }
        finally {
            if (responseEntity != null) {
                EntityUtils.consume((HttpEntity)responseEntity);
            }
        }
    }

    public static String buildPath(String root, String path) {
        String trimmedRoot = root.endsWith("/") ? root.substring(0, root.length() - 1) : root;
        return trimmedRoot + "/az/v1/" + path;
    }

    public static String toggleAccessTokenAndAuthHeader(String accessTokenOrAuthHeader, boolean authHeaderToToken) {
        if (authHeaderToToken) {
            return accessTokenOrAuthHeader.substring(BEARER.length()).trim();
        }
        return "Bearer " + accessTokenOrAuthHeader;
    }

    public static TokenIntrospectionData toTokenIntrospectionData(String entity) throws IOException {
        Map<String, Object> map = TokenValidationUtils.toMap(entity);
        Object expObject = map.remove("exp");
        long exp = expObject instanceof Integer ? new Long(((Integer)expObject).intValue()).longValue() : ((Long)expObject).longValue();
        String scope = (String)map.remove("scope");
        boolean active = (Boolean)map.remove("active");
        TokenIntrospectionData result = new TokenIntrospectionData(scope, exp, active);
        result.setData(map);
        return result;
    }

    public static Map<String, Object> toMap(String entity) throws IOException {
        return (Map)TokenValidationUtils.getMapper().readValue(entity, Map.class);
    }
}

