/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mfp.java.token.validator;

import com.ibm.mfp.java.token.validator.AuthenticationError;
import com.ibm.mfp.java.token.validator.TokenIntrospectionData;
import com.ibm.mfp.java.token.validator.TokenValidationCache;
import com.ibm.mfp.java.token.validator.TokenValidationException;
import com.ibm.mfp.java.token.validator.TokenValidationResult;
import com.ibm.mfp.java.token.validator.utils.TokenValidationUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.message.BasicNameValuePair;

public class TokenValidationManager {
    private static final String BEARER = "Bearer";
    private static final String INTROSPECTION_PATH = "introspection";
    private static final String TOKEN_PATH = "token";
    private static final long DEFAULT_CACHE_SIZE = 50000L;
    private static final String INTROSPECTION_SCOPE_KEY = "authorization.introspect";
    public static final String INVALID_TOKEN_ERROR = "invalid_token";
    private static final Logger logger = Logger.getLogger(TokenValidationManager.class.getName());
    private static final String ACCESS_TOKEN_KEY = "access_token";
    private static final String EXPIRATION = "expires_in";
    private TokenValidationCache cache;
    private URI authorizationURI;
    private String basicAuthorization;
    private int attempts;
    private String resourceConfidentialToken;
    private long resourceConfidentialTokenExpiration;

    public TokenValidationManager(URI authorizationURI, String clientId, String clientSecret, long cacheSize) throws TokenValidationException {
        if (authorizationURI == null) {
            throw new TokenValidationException("Missing parameters");
        }
        this.authorizationURI = authorizationURI;
        this.cache = new TokenValidationCache(cacheSize);
        if (clientId != null && clientSecret != null) {
            this.basicAuthorization = "Basic " + Base64.encodeBase64String((byte[])(clientId + ":" + clientSecret).getBytes());
        } else {
            logger.log(Level.FINE, "No clientId or clientSecret passed, if you are working in embedded-AZ mode, token validation will fail");
        }
    }

    public TokenValidationManager(URI authorizationURI, String clientId, String clientSecret) throws TokenValidationException {
        this(authorizationURI, clientId, clientSecret, 50000L);
    }

    public TokenValidationResult validate(String authorizationHeader, String expectedScope) throws TokenValidationException {
        AuthenticationError error = this.preProcessAuthHeader(authorizationHeader);
        if (error != null) {
            return new TokenValidationResult(error, null);
        }
        return this.introspect(authorizationHeader, expectedScope);
    }

    public TokenValidationResult validate(String authorizationHeader) throws TokenValidationException {
        return this.validate(authorizationHeader, null);
    }

    public Map<String, Object> obtainAccessToken(String scope) throws TokenValidationException {
        Map<String, Object> accessToken;
        String response;
        String path = TokenValidationUtils.buildPath(this.authorizationURI.toString(), TOKEN_PATH);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.hasBasicCredentials()) {
            headers.put("Authorization", this.basicAuthorization);
        }
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        formParams.add(new BasicNameValuePair("grant_type", "client_credentials"));
        formParams.add(new BasicNameValuePair("scope", scope));
        try {
            response = TokenValidationUtils.makePostRequest(path, headers, formParams);
            accessToken = TokenValidationUtils.toMap(response);
        }
        catch (Exception e) {
            logger.severe("Unable to obtain access token, if working in external-AZ mode, verify you have set clientId/clientSecret to null");
            throw new TokenValidationException("Failed to make token request, reason: " + e.getMessage(), e);
        }
        if (accessToken.get(ACCESS_TOKEN_KEY) == null) {
            throw new TokenValidationException("Failed to make token request, " + response);
        }
        return accessToken;
    }

    private AuthenticationError preProcessAuthHeader(String authorizationHeader) {
        String token;
        if (authorizationHeader == null || authorizationHeader.length() < 1) {
            return new AuthenticationError(401, this.buildErrorMessage(null, null));
        }
        String string = token = authorizationHeader.startsWith(BEARER) ? authorizationHeader.substring(BEARER.length()) : "";
        if (token.isEmpty()) {
            return new AuthenticationError(401, this.buildErrorMessage(INVALID_TOKEN_ERROR, null));
        }
        return null;
    }

    private TokenValidationResult introspect(String authorizationHeader, String expectedScope) throws TokenValidationException {
        AuthenticationError authError = null;
        this.obtainToken();
        TokenIntrospectionData data = this.cache.get(authorizationHeader);
        if (data == null) {
            try {
                data = this.makeIntrospectionRequest(authorizationHeader);
                this.cache.set(authorizationHeader, data);
            }
            catch (TokenValidationException e) {
                authError = this.handleConflictFailure(e);
            }
        }
        authError = authError != null ? authError : this.validateIntrospectionDataResponse(data, expectedScope);
        data = authError != null ? TokenIntrospectionData.INACTIVE_TOKEN : data;
        return new TokenValidationResult(authError, data);
    }

    private AuthenticationError validateIntrospectionDataResponse(TokenIntrospectionData data, String requiredScope) {
        if (data == null) {
            return new AuthenticationError(401, this.buildErrorMessage(INVALID_TOKEN_ERROR, null));
        }
        if (!data.isActive()) {
            return new AuthenticationError(401, this.buildErrorMessage(INVALID_TOKEN_ERROR, null));
        }
        if (requiredScope != null && !data.isScopeCovered(requiredScope)) {
            return new AuthenticationError(403, this.buildErrorMessage("insufficient_scope", requiredScope));
        }
        return null;
    }

    protected TokenIntrospectionData makeIntrospectionRequest(String authorizationHeader) throws TokenValidationException {
        String path = TokenValidationUtils.buildPath(this.authorizationURI.toString(), INTROSPECTION_PATH);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.getResourceConfidentialToken() != null) {
            headers.put("Authorization", TokenValidationUtils.toggleAccessTokenAndAuthHeader(this.getResourceConfidentialToken(), false));
        }
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        String token = TokenValidationUtils.toggleAccessTokenAndAuthHeader(authorizationHeader, true);
        formParams.add(new BasicNameValuePair(TOKEN_PATH, token));
        formParams.add(new BasicNameValuePair("token_type_hint", ACCESS_TOKEN_KEY));
        try {
            String response = TokenValidationUtils.makePostRequest(path, headers, formParams);
            return TokenValidationUtils.toTokenIntrospectionData(response);
        }
        catch (Exception e) {
            if (e instanceof TokenValidationException) {
                return this.handleIntrospectionFailure(authorizationHeader, (TokenValidationException)e);
            }
            throw new TokenValidationException("Failed to make introspection request, reason: " + e.getMessage(), e);
        }
    }

    private TokenIntrospectionData handleIntrospectionFailure(String authorizationHeader, TokenValidationException e) throws TokenValidationException {
        int responseStatus = e.getStatus();
        if (responseStatus == 401 || responseStatus == 403) {
            return this.handleUnauthorizedFailure(authorizationHeader);
        }
        throw e;
    }

    private boolean hasBasicCredentials() {
        return this.basicAuthorization != null;
    }

    private TokenIntrospectionData handleUnauthorizedFailure(String authorizationHeader) throws TokenValidationException {
        int maxAttempts = 4;
        if (++this.attempts < maxAttempts) {
            this.setResourceConfidentialToken(null);
            this.obtainToken();
            return this.makeIntrospectionRequest(authorizationHeader);
        }
        logger.severe("Introspection endpoint resulted in unauthorized response, if you are working in embedded AZ server, you must provide non-null clientId/clientSecret credentials");
        throw new TokenValidationException("Error obtaining a token for the Resource Server using the specified clientId/clientSecret credentials");
    }

    private AuthenticationError handleConflictFailure(TokenValidationException e) throws TokenValidationException {
        if (e.getStatus() != 409) {
            throw e;
        }
        AuthenticationError authError = new AuthenticationError(409, null);
        return authError;
    }

    private void obtainToken() throws TokenValidationException {
        if (this.shouldObtainToken()) {
            Map<String, Object> accessToken = this.obtainAccessToken(INTROSPECTION_SCOPE_KEY);
            this.setResourceConfidentialToken(accessToken);
        }
    }

    private String buildErrorMessage(String error, String scope) {
        StringBuilder sb = new StringBuilder();
        sb.append(BEARER);
        if (error != null) {
            sb.append(" error=\"").append(error).append("\"");
        }
        if (scope != null) {
            sb.append(", scope=\"").append(scope).append("\"");
        }
        return sb.toString();
    }

    private boolean shouldObtainToken() {
        return this.hasBasicCredentials() && this.getResourceConfidentialToken() == null;
    }

    private String getResourceConfidentialToken() {
        if (System.currentTimeMillis() >= this.resourceConfidentialTokenExpiration) {
            this.setResourceConfidentialToken(null);
        }
        return this.resourceConfidentialToken;
    }

    private void setResourceConfidentialToken(Map<String, Object> accessTokenResponse) {
        if (accessTokenResponse == null) {
            this.resourceConfidentialToken = null;
            this.resourceConfidentialTokenExpiration = 0L;
        } else {
            this.resourceConfidentialToken = (String)accessTokenResponse.get(ACCESS_TOKEN_KEY);
            Number expiration = (Number)accessTokenResponse.get(EXPIRATION);
            this.resourceConfidentialTokenExpiration = System.currentTimeMillis() + expiration.longValue() * 1000L;
        }
    }
}

