/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mfp.java.token.validator;

import com.ibm.mfp.java.token.validator.TokenIntrospectionData;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;

class TokenValidationCache {
    Map<String, TokenIntrospectionData> cache;
    Queue<String> cacheList;
    long maxCacheSize = 0L;
    long cacheSizeCounter = 0L;

    public TokenValidationCache(long cacheSize) {
        this.maxCacheSize = cacheSize;
        this.cache = new HashMap<String, TokenIntrospectionData>();
        this.cacheList = new LinkedList<String>();
    }

    public void set(String authHeader, TokenIntrospectionData data) {
        if (this.cacheSizeCounter >= this.maxCacheSize) {
            this.removeOldest();
        }
        if (this.cacheSizeCounter < this.maxCacheSize) {
            this.cache.put(authHeader, data);
            this.cacheList.add(authHeader);
            ++this.cacheSizeCounter;
        }
    }

    public TokenIntrospectionData get(String authHeader) {
        TokenIntrospectionData data = this.cache.get(authHeader);
        if (data != null && data.isActive() && this.isExpired(data)) {
            this.cache.remove(authHeader);
            --this.cacheSizeCounter;
            data = TokenIntrospectionData.INACTIVE_TOKEN;
        }
        return data;
    }

    private void removeOldest() {
        try {
            String removedKey = this.cacheList.remove();
            TokenIntrospectionData removedData = this.cache.remove(removedKey);
            if (removedData != null) {
                --this.cacheSizeCounter;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private boolean isExpired(TokenIntrospectionData introspectionData) {
        long currentTime = System.currentTimeMillis();
        return introspectionData.getExpiration() <= currentTime;
    }
}

