/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mfp.java.token.validator;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;

public class TokenIntrospectionData {
    public static final TokenIntrospectionData INACTIVE_TOKEN = new TokenIntrospectionData();
    private boolean active;
    private String scope;
    @JsonProperty(value="exp")
    private long expiration;
    private Map<String, Object> data;

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public TokenIntrospectionData(String scope, long expiration, boolean active) {
        this.scope = scope;
        this.expiration = expiration;
        this.active = active;
    }

    public TokenIntrospectionData(String scope, long expiration) {
        this.scope = scope;
        this.expiration = expiration;
        this.active = true;
    }

    public TokenIntrospectionData() {
    }

    public boolean isActive() {
        return this.active;
    }

    public String getScope() {
        return this.scope;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public boolean isScopeCovered(String requiredScope) {
        StringTokenizer tokenizer;
        HashSet<String> grantedTokens = new HashSet<String>();
        if (this.scope != null) {
            tokenizer = new StringTokenizer(this.scope, " ");
            while (tokenizer.hasMoreTokens()) {
                grantedTokens.add(tokenizer.nextToken());
            }
        }
        tokenizer = new StringTokenizer(requiredScope, " ");
        while (tokenizer.hasMoreTokens()) {
            if (grantedTokens.contains(tokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }
}

