/*
* © Copyright IBM Corp. 2016
* All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*/

package com.worklight.adapters.rest.api;

/**
 * API to get values of configuration properties during runtime (both worklight.properties and JNDI properties)
 * @deprecated This interface is deprecated since V8.0, use {@link com.ibm.mfp.adapter.api.ConfigurationAPI} instead.
 */

@Deprecated
public interface ConfigurationAPI {

	/**
	 * Does exactly the same as getServerJNDIProperty,
	 * This method is still there for backwards compatibility reason and it is deprecated.
	 * In MFP 7.1 and older versions we used to have this method to look at JNDI, and if the property was missing
	 * from there, it was looking at worklight.properties inside the WAR
	 *
	 * Since that starting from 8.0.0 there is no WAR customization, there is no worklight.properties in the WAR
	 * Thus this method only looks at the JNDI and hence it is identical to getServerJNDIProperty below
	 *
	 * Take a look at: com.ibm.mfp.adapter.api.ConfigurationAPI - we recommend to use it instead
	 *
	 * @param name - The property's name
	 * @return - The value of the property or null if the property is not defined.
	 */
	 String getMFPConfigurationProperty(String name);
	
	/**
	 * Get JNDI property from the server configuration.
	 * 
	 * @param name - The property's name
	 * @return The value of the property or null if the property is not defined
	 */
	 String getServerJNDIProperty(String name);
}
