/*
* © Copyright IBM Corp. 2016
* All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*/

package com.worklight.adapters.rest.api;

import java.io.IOException;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

import com.ibm.json.java.JSONObject;

/**
 * API to send REST requests to other adapters (both Java and Javascript adapters)
 *@deprecated This interface is deprecated since V8.0, use {@link com.ibm.mfp.adapter.api.AdaptersAPI} instead.
 */

@Deprecated
public interface AdaptersAPI {

	/**
	 * Sends HTTP request to another REST or Javascript adapter.
	 * 
	 * @param request - Apache {@link HttpUriRequest} to be sent to the adapter. The URI of this request must not be
	 * absolute. It must be relative to the "/adapters" endpoint. For example: "/myadapter/getStories" 
	 * @return
	 * The response (standard {@link HttpResponse})
	 * @throws IOException
	 * @throws MFPServerOAuthException 
	 */
	public HttpResponse executeAdapterRequest(HttpUriRequest request) throws IOException, MFPServerOAuthException;
	
	/**
	 * Reads the response to JSON. It assumes that the response contains a JSON content.
	 * 
	 * @param response - The response to be read
	 * @return A JSON object with the response content
	 * @throws IOException
	 */
	public JSONObject getResponseAsJSON(HttpResponse response) throws IOException;
	
	/**
	 * Helper method to create request to a JS adapter (via REST)
	 * 
	 * @param adapter - The adapter name
	 * @param procedure - The procedure name
	 * @param args - Arguments to be passed (Optional)
	 * @return
	 */
	public HttpUriRequest createJavascriptAdapterRequest(String adapter, String procedure, Object... args);
}
