/*
* © Copyright IBM Corp. 2016
* All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*/

package com.ibm.mfp.server.security.external.checks.impl;

import java.util.Properties;

/**
 * Defines inactivity timeout property
 * Default value is 0, which means inactivity timeout disabled
 *
 * @author artem on 11/12/15.
 */
public class ExternalizableSecurityCheckConfig extends SecurityCheckConfigurationBase {

    public static final String INACTIVITY_TIMEOUT_SEC_CONFIG = "inactivityTimeoutSec";

    public int inactivityTimeoutSec;

    public ExternalizableSecurityCheckConfig(Properties properties) {
        inactivityTimeoutSec = getIntProperty(INACTIVITY_TIMEOUT_SEC_CONFIG, properties, 0);
    }

    @Override
    public void validateExpirationLimit(int expirationLimitSec){
        if(inactivityTimeoutSec > expirationLimitSec) {
            addMessage(warnings, INACTIVITY_TIMEOUT_SEC_CONFIG, "property value is greater than the expiration limit.");
            inactivityTimeoutSec = expirationLimitSec;
        }
    }
}
