/*
* © Copyright IBM Corp. 2016
* All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*/

package com.ibm.mfp.server.security.external.checks;

import java.util.Map;
import java.util.Properties;

/**
 * Represents the configuration of a security check.<br/>
 * Is created during deployment via {@link SecurityCheck#createConfiguration(Properties)}, and used at runtime.<br/>
 * The subclasses are responsible for reading the configuration data from the Properties object and validating it.
 * Validation errors are reported automatically to the deployment UI.
 *
 * @author artem on 11/16/15.
 */
public interface SecurityCheckConfiguration {

    /**
     * Get validation errors as a map with property name as key and error message as value
     *
     * @return validation errors, may be null
     */
    Map<String, String> getErrors();

    /**
     * Get validation warnings as a map with property name as key and warning message as value
     *
     * @return validation warnings, may be null
     */
    Map<String, String> getWarnings();

    /**
     * Get validation warnings as a map with property name as key and warning message as value
     *
     * @return validation warnings, may be null
     */
    Map<String, String> getInfo();

    /**
     * Make sure the configuration values representing expiration or inactivity don't exceed the given limit.<br/>
     * The implementation can use this method to implement other time-related validations,
     * for example that inactivity is less than expiration, etc.<br/>
     * The implementation may decide to fix the discovered problems by replacing too large values with the limit, and report a warning.
     *
     * @param expirationLimitSec - max time the security check state can be preserved
     */
    void validateExpirationLimit(int expirationLimitSec);
}
