/*
* © Copyright IBM Corp. 2016
* All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*/

package com.ibm.mfp.server.security.external.checks;

import com.ibm.mfp.server.registration.external.model.ClientData;
import com.ibm.mfp.server.registration.external.model.PersistentAttributes;
import com.ibm.mfp.server.registration.external.model.AuthenticatedUser;
import com.ibm.mfp.server.security.external.resource.ClientSearchCriteria;

import java.util.List;

/**
 * Persistent/deployment data associated with the current client
 *
 * @author artem on 11/22/15.
 */
public interface RegistrationContext {

    /**
     * Get the user registered by this security check for the current client
     *
     * @return the authenticated user, null if the client is not mobile, or no user was registered.
     */
    AuthenticatedUser getRegisteredUser();

    /**
     * Register the given user for the current client.
     * If the current client is not mobile, the call does nothing.
     *
     * @param user authenticated user
     */
    void setRegisteredUser(AuthenticatedUser user);

    /**
     * Get the public persistent attributes of the current client.
     *
     * @return modifyable persistent attributes, null if the current client is not mobile
     */
    PersistentAttributes getRegisteredPublicAttributes();

    /**
     * Get the protected persistent attributes of the current client.
     *
     * @return modifyable persistent attributes, null if the current client is not mobile
     */
    PersistentAttributes getRegisteredProtectedAttributes();

    /**
     * Find the registration data of mobile clients by the given search criteria
     *
     * @param criteria the search criteria
     * @return list of clients satisfying the given criteria
     */
    List<ClientData> findClientRegistrationData(ClientSearchCriteria criteria);

    /**
     * Get the ClientData object for the current client.
     * @return the current client
     */
    ClientData getClientData();
}
