/*
* © Copyright IBM Corp. 2016
* All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*/

package com.ibm.mfp.server.security.external.checks;

import java.util.Map;
import java.util.Set;

/**
 * Aggregates introspection responses from multiple security checks.
 *
 * @author artem on 2/16/16.
 */
public interface IntrospectionResponse {

    /**
     * Add granted scope and custom introspection data to the response
     *
     * @param securityCheckName       the reporting security check
     * @param scope                   the scope granted by the check
     * @param expiresAt               granted scope expiration time. Must be greater than now, otherwise the data is ignored
     * @param customIntrospectionData additional introspection data provided by the security check
     */
    void addIntrospectionData(String securityCheckName, Set<String> scope, long expiresAt, Map<String, String> customIntrospectionData);
}
