/*
* © Copyright IBM Corp. 2016
* All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*/

package com.ibm.mfp.server.security.external.checks;

import com.ibm.mfp.server.registration.external.model.AuthenticatedUser;

/**
 * Transient data associated with the current client for the security check
 *
 * @author artem
 *         Date: 8/30/15
 */
public interface AuthorizationContext {

    /**
     * Get authenticated user set by this security check for the current client
     *
     * @return the active user, null is has not been set or has expired
     */
    AuthenticatedUser getActiveUser();

    /**
     * Set the active user for the current client by this security check
     *
     * @param user authenticated user, not null
     */
    void setActiveUser(AuthenticatedUser user);
}
