/*
* © Copyright IBM Corp. 2016
* All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*/

package com.ibm.mfp.server.registration.external.model;

import com.ibm.mfp.server.app.external.ApplicationKey;

import java.util.HashMap;
import java.util.Map;

/**
 * Data provided by the mobile client upon registration
 *
 * @author artem
 *         Date: 6/29/15
 */
public class RegistrationData {

    private ApplicationKey application;
    private DeviceData device;
    private Map<String, Object> attributes = new HashMap<>();

    /**
     * Reserved for internal use only. Adapters should use ClientData.getRegistration() to get the registration data.
     */
    public RegistrationData() {
    }

    /**
     * Reserved for internal use only. Adapters should use ClientData.getRegistration() to get the registration data.
     *
     * @param that
     */
    public RegistrationData(RegistrationData that) {
        this.application = new ApplicationKey(that.application.getClientPlatform(), that.application.getId(), that.application.getVersion());
        this.device = that.device == null ? null : new DeviceData(that.device.getId(), that.device.getHardware(), that.device.getPlatform());
    }

    /**
     * Reserved for internal use only. Adapters should use ClientData.getRegistration() to get the registration data.
     *
     * @param application            the application key
     * @param clientRegistrationData device data for mobile app or browser data for web app
     */
    public RegistrationData(ApplicationKey application, DeviceData clientRegistrationData, Map<String, Object> attributes) {
        this.application = application;
        this.device = clientRegistrationData;
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    /**
     * Reserved for internal use only.
     *
     * @param that
     * @return
     * @throws Exception
     */
    public boolean updateFrom(RegistrationData that) throws Exception {
        boolean reRegisterApp = this.application == null || this.application.updateFrom(that.application);
        boolean reRegisterDevice = this.device == null || this.device.updateFrom(that.device);

        this.attributes.clear();
        if (that.attributes != null) {
            this.attributes.putAll(that.attributes);
        }

        return reRegisterApp || reRegisterDevice;
    }

    /**
     * Gets the application key.
     *
     * @return the application key
     */
    public ApplicationKey getApplication() {
        return application;
    }

    /**
     * Gets the data of the device.
     *
     * @return the data of the device.
     */
    public DeviceData getDevice() {
        return device;
    }

    /**
     * Gets the attributes map sent by the client during registration.
     *
     * @return a map
     */
    public Map<String, Object> getAttributes() {
        return attributes;
    }

}
