/*
 * IBM Confidential OCO Source Materials
 *
 * 5725-I43 Copyright IBM Corp. 2006, 2016
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */

package com.ibm.mfp.server.registration.external.device.management;

/**
 * The current access rights of the device. The possible status values are <code>ACTIVE</code>, <code>LOST</code>, <code>STOLEN</code>,
 * <code>EXPIRED</code> and <code>DISABLED</code>.
 * A device with a status of <code>LOST</code>, <code>STOLEN</code>, or <code>DISABLED</code> is not allowed to access protected resources.
 * The status <code>EXPIRED</code> indicates that the device has not connected to the MobileFirst Server for a certain configurable period.
 *
 * @author artem on 12/10/15.
 */
public enum MFPDeviceStatus {
    /**
     * An active device
     */
    ACTIVE(0),

    /**
     * A device that has been marked as lost by the administrator
     */
    LOST(1),

    /**
     * A device that has been marked as stolen by the administrator
     */
    STOLEN(2),

    /**
     * A device that has not connected to the MobileFirst Server for a certain configurable period
     */
    EXPIRED(3),

    /**
     * A device that has been disabled
     */
    DISABLED(4);

    /**
     * A numeric identifier for the status
     */
    public final int value;

    private MFPDeviceStatus(int value) {
        this.value = value;
    }

    /**
     * Returns the device status with the specified numeric identifier
     * @param v the numeric identifier
     * @return the status represented by the given identifier
     */
    public static MFPDeviceStatus valueOf(int v) {
        for (MFPDeviceStatus x : values()) {
            if (x.value == v) {
                return x;
            }
        }
        throw new IllegalArgumentException("invalid DeviceStatus value: "+v);
    }
}
