/*
* © Copyright IBM Corp. 2016
* All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*/

package com.ibm.mfp.adapter.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation is used to configure protection of Java API for RESTful Web Services (JAX-RS) adapter resources.<br/>
 * The MobileFirst security framework provides default resource protection: access to any MobileFirst adapter resources requires
 * an access token, and the framework verifies that the request is issued from an application that is registered with MobileFirst Server.<br/>
 * Use this annotation to assign custom security scopes to your resources, or to disable the default MobileFirst resource protection.<br/>
 * The annotation can be applied either to a specific resource method or to an entire resource class.
 * Method-level annotations override class-level annotations. 
 *
 * @author artem
 *         Date: 8 Aug, 2015
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface OAuthSecurity {

    String DEFAULT_SCOPE = "RegisteredClient";

    /**
     * Optional. The scope that protects the resource, as a string of one or more space-separated scope elements.
     * A scope element can be a keyword that is mapped to a security check, or the name of a security check.<br/>
     * The default value of this element is "RegisteredClient", which applies the default MobileFirst resource protection.<br/>
     * When the value of the {@link #enabled} element is {@code false}, the {@code scope} element is ignored.
     * @return The protecting scope.
     */
    String scope() default DEFAULT_SCOPE;

    /**
     * Optional. The resource-protection state:
     * <ul>
     *     <li>{@code true}  - The resource is protected and requires an access token. This is the default value.</li>
     *     <li>{@code false} - The resource is not protected and does not require an access token.<br/>
     *                         When this value is set, the {@link #scope} element is ignored.
     *     </li>
     * </ul>
     * @return {@code true} if the resource is protected, or {@code false} if it is not protected.
     */
    boolean enabled() default true;
}

