/*
* © Copyright IBM Corp. 2016
* All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*/

package com.ibm.mfp.adapter.api;

/**
 * API to get values of configuration properties during runtime (both worklight.properties and JNDI properties)
 *
 */


/**
 * API to get values of configuration properties during runtime.
 * This API is accessible using the Jax-RS {@literal@}Context annotation, for example by defining a member varaible:
 * <pre>
 <code>
 {@literal@}Context
 private ConfigurationAPI configurationApi;
 }
 </code>
 </pre>
 *
 */
public interface ConfigurationAPI {

	/**
	 * Helper method to retrieve JNDI properties from the server configuration.
	 * 
	 * @param name - The property's name
	 * @return The value of the property or null if the property is not defined
	 */
	String getServerJNDIProperty(String name);

	/**
	 * Gets the property value for the given property name. This method will return
	 * the value from the adapter configuration, if it was defined. Otherwise the default
	 * value (defined in the adapter descriptor) will be returned. <br/>
	 * This method returns all values as strings. If a different type is required, it must be
	 * explicitly converted to the appropriate type.
	 *
	 * @param propertyName The name of the property
	 * @return A string representation of the property value.
     */
	String getPropertyValue(String propertyName);


   /**
    * Returns the list of properties defined in the adapter descriptor
    * @return The names of all the properties defined in the adapter descriptor
    */
    String[] getPropertyNames();
}
