/*
* © Copyright IBM Corp. 2016
* All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*/

package com.ibm.mfp.adapter.api;


/**
 * API for reporting information to analytics.
 * This API is accessible using the Jax-RS {@literal@}Context annotation, for example by defining a member varaible:
 * <pre>
 <code>
 {@literal@}Context
 private AnalyticsAPI analyticsApi;
 }
 </code>
 </pre>
 *
 */
public interface AnalyticsAPI {
	/**
	 * Report user activity. This method is used to report user activity for
	 * auditing or reporting purposes. The IBM® MobileFirst® server maintains a
	 * separate database table to store application statistics.
     * The data from logActivity is sent to the Operational Analytics
	 * feature.
	 * 
	 * @param activityType
	 *            - A string that identifies the activity.
	 * 
	 * 
	 */
	 void logActivity(String activityType);

}
