/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.locks.ReentrantLock;

public final class BlockWriter
extends PrintWriter {
    private int blockDepth = 0;
    private int lastWrittenBlockDepth = -1;
    private boolean autoStartedBlock = false;
    private boolean empty = true;
    private StringWriter buffer = null;
    private String prependNewLineString = null;
    private boolean prependShouldAddBeforeNextWrite = true;
    private final ReentrantLock prependingLock = new ReentrantLock();
    private boolean atLineStart = true;

    public static BlockWriter create() {
        return BlockWriter.create(new StringWriter());
    }

    public static BlockWriter create(int initialSize) {
        return BlockWriter.create(new StringWriter(initialSize));
    }

    private static BlockWriter create(StringWriter buffer) {
        BlockWriter bw = new BlockWriter(buffer);
        bw.buffer = buffer;
        return bw;
    }

    public BlockWriter(Writer out) {
        super(out);
    }

    public BlockWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public BlockWriter(OutputStream out) {
        super(out);
    }

    public BlockWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    @Override
    public void write(int c) {
        this.testNewBlock();
        super.write(c);
        this.atLineStart = false;
        if (c == 10) {
            this.atLineStart = true;
            this.prependAfterNewline();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (len == 0) {
            return;
        }
        this.testNewBlock();
        if (this.prependNewLineString != null && !this.prependingLock.isLocked()) {
            this.writePrepended(cbuf, off, len);
        } else {
            super.write(cbuf, off, len);
            this.atLineStart = cbuf[off + len - 1] == '\n';
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePrepended(char[] cbuf, int off, int len) {
        this.prependingLock.lock();
        try {
            int start = off;
            for (int i = off; i < off + len; ++i) {
                if (cbuf[i] != '\n') continue;
                this.write(cbuf, start, i + 1 - start);
                this.writePrepend();
                start = i + 1;
            }
            if (start < off + len) {
                this.write(cbuf, start, off + len - start);
            }
        }
        finally {
            this.prependingLock.unlock();
        }
    }

    @Override
    public void write(String s, int off, int len) {
        if (len == 0) {
            return;
        }
        this.testNewBlock();
        if (this.prependNewLineString != null && s.indexOf(10) != -1 && !this.prependingLock.isLocked()) {
            this.writePrepended(s, off, len);
        } else {
            super.write(s, off, len);
            this.atLineStart = s.charAt(off + len - 1) == '\n';
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePrepended(String s, int off, int len) {
        this.prependingLock.lock();
        try {
            int start = off;
            for (int i = off; i < off + len; ++i) {
                if (s.charAt(i) != '\n') continue;
                this.write(s, start, i + 1 - start);
                this.writePrepend();
                start = i + 1;
            }
            if (start < off + len) {
                this.write(s, start, off + len - start);
            }
        }
        finally {
            this.prependingLock.unlock();
        }
    }

    @Override
    public void println() {
        this.testFirstPrepend();
        super.println();
        this.atLineStart = true;
        this.prependAfterNewline();
    }

    private void prependAfterNewline() {
        if (this.prependNewLineString != null && !this.prependingLock.isLocked()) {
            this.prependingLock.lock();
            try {
                this.writePrepend();
            }
            finally {
                this.prependingLock.unlock();
            }
        }
    }

    public void testNewBlock() {
        this.testFirstPrepend();
        if (this.blockDepth == 0) {
            this.startBlock();
            this.autoStartedBlock = true;
        }
        if (this.lastWrittenBlockDepth != this.blockDepth) {
            if (this.empty) {
                this.empty = false;
            } else {
                this.println();
                this.println();
                this.atLineStart = true;
            }
            this.lastWrittenBlockDepth = this.blockDepth;
        }
    }

    private void testFirstPrepend() {
        if (this.prependShouldAddBeforeNextWrite && this.prependNewLineString != null && !this.prependingLock.isLocked()) {
            this.prependingLock.lock();
            try {
                this.writePrepend();
            }
            finally {
                this.prependingLock.unlock();
            }
            this.prependShouldAddBeforeNextWrite = false;
        }
    }

    private void writePrepend() {
        super.write(this.prependNewLineString, 0, this.prependNewLineString.length());
        if (this.prependNewLineString.endsWith("\n")) {
            this.atLineStart = true;
        } else if (this.prependNewLineString.length() != 0) {
            this.atLineStart = false;
        }
    }

    public void startBlock() {
        if (this.autoStartedBlock) {
            this.autoStartedBlock = false;
            this.endBlock();
        }
        ++this.blockDepth;
    }

    public void endBlock() {
        if (this.blockDepth > 0) {
            --this.blockDepth;
        }
        this.lastWrittenBlockDepth = -1;
    }

    public void writeBlock(Object blockText) {
        this.startBlock();
        this.print(blockText);
        if (String.valueOf(blockText).endsWith("\n")) {
            this.atLineStart = true;
        } else if (String.valueOf(blockText).length() != 0) {
            this.atLineStart = false;
        }
        this.endBlock();
    }

    public void printBlock(Object blockText) {
        this.writeBlock(blockText);
    }

    public int getBlockDepth() {
        return this.blockDepth;
    }

    public boolean isAtLineStart() {
        return this.atLineStart;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public StringWriter getBuffer() {
        return this.buffer;
    }

    public String getPrependNewlineString() {
        return this.prependNewLineString;
    }

    public BlockWriter setPrependNewlineString(String prependNewLineString) {
        this.prependNewLineString = prependNewLineString;
        this.prependShouldAddBeforeNextWrite = true;
        return this;
    }

    public BlockWriter setPrependNewlineString(String prependNewLineString, boolean skipFirstLine) {
        this.prependNewLineString = prependNewLineString;
        this.prependShouldAddBeforeNextWrite = !skipFirstLine;
        return this;
    }

    public String toString() {
        if (this.buffer != null) {
            this.flush();
            return this.buffer.toString();
        }
        return super.toString();
    }
}

