/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.Options;
import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.convert.ProvenanceWriter;
import com.overzealous.remark.util.MarkdownTable;
import com.overzealous.remark.util.MarkdownTableCell;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class Table
extends AbstractNodeHandler {
    private static final Pattern STYLE_ALIGNMENT_PATTERN = Pattern.compile("text-align:\\s*([a-z]+)", 2);

    @Override
    public Node handleNode(NodeHandler parent, Element node, DocumentConverter converter, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel) {
        Node result = null;
        MarkdownTable table = new MarkdownTable();
        int depthLevel = 0;
        String nextLevel = level + ".";
        for (Element child : node.children()) {
            String nextNextLevel;
            int nextDepthLevel;
            if (searchLevel != null && searchLevel.equals(nextLevel + ++depthLevel)) {
                return child;
            }
            if (child.tagName().equals("thead")) {
                nextDepthLevel = 0;
                nextNextLevel = nextLevel + depthLevel + ".";
                for (Element headerRow : child.children()) {
                    if (searchLevel != null && searchLevel.equals(nextNextLevel + ++nextDepthLevel)) {
                        return headerRow;
                    }
                    result = this.processRow(table.addHeaderRow(), headerRow, converter, pw, baseUri, domain, nextNextLevel + nextDepthLevel, searchLevel);
                    if (result == null) continue;
                    return result;
                }
                continue;
            }
            if (child.tagName().equals("tbody") || child.tagName().equals("tfoot")) {
                nextDepthLevel = 0;
                nextNextLevel = nextLevel + depthLevel + ".";
                for (Element bodyRow : child.children()) {
                    if (searchLevel != null && searchLevel.equals(nextNextLevel + ++nextDepthLevel)) {
                        return bodyRow;
                    }
                    result = this.processRow(table.addBodyRow(), bodyRow, converter, pw, baseUri, domain, nextNextLevel + nextDepthLevel, searchLevel);
                    if (result == null) continue;
                    return result;
                }
                continue;
            }
            if (!child.tagName().equals("tr") || child.children().isEmpty()) continue;
            if (((Element)child.children().get(0)).tagName().equals("th")) {
                if (searchLevel != null && searchLevel.equals(nextLevel + depthLevel + "." + 1)) {
                    return child;
                }
                result = this.processRow(table.addHeaderRow(), child, converter, pw, baseUri, domain, nextLevel + depthLevel + "." + 1, searchLevel);
                if (result == null) continue;
                return result;
            }
            result = this.processRow(table.addBodyRow(), child, converter, pw, baseUri, domain, nextLevel + depthLevel, searchLevel);
            if (result == null) continue;
            return result;
        }
        Options.Tables opts = converter.options.getTables();
        converter.output.startBlock();
        table.renderTable(converter.output, opts.isColspanEnabled(), opts.isRenderedAsCode());
        converter.output.endBlock();
        return result;
    }

    private Node processRow(List<MarkdownTableCell> row, Element tableRow, DocumentConverter converter, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel) {
        Node result = null;
        int depthLevel = 0;
        String nextLevel = level + "~";
        for (Element cell : tableRow.children()) {
            if (searchLevel != null && searchLevel.equals(nextLevel + ++depthLevel)) {
                return cell;
            }
            HashSet<Node> nodeSet = new HashSet<Node>();
            String contents = converter.getInlineContent(this, cell, true, pw, baseUri, domain, level, searchLevel, nodeSet);
            if (nodeSet.size() != 0) {
                return (Node)nodeSet.iterator().next();
            }
            row.add(new MarkdownTableCell(contents, this.getAlignment(cell), this.getColspan(cell)));
            this.saveAnnotation(pw, nextLevel + depthLevel, cell, contents.replaceAll("\n", " "));
        }
        return result;
    }

    private MarkdownTable.Alignment getAlignment(Element cell) {
        Matcher m;
        MarkdownTable.Alignment alignment = MarkdownTable.Alignment.LEFT;
        String alignmentString = null;
        if (cell.hasAttr("align")) {
            alignmentString = cell.attr("align").toLowerCase();
        } else if (cell.hasAttr("style") && (m = STYLE_ALIGNMENT_PATTERN.matcher(cell.attr("style"))).find()) {
            alignmentString = m.group(1).toLowerCase();
        }
        if (alignmentString != null) {
            if (alignmentString.equals("center")) {
                alignment = MarkdownTable.Alignment.CENTER;
            } else if (alignmentString.equals("right")) {
                alignment = MarkdownTable.Alignment.RIGHT;
            }
        }
        return alignment;
    }

    private int getColspan(Element cell) {
        int colspan = 1;
        if (cell.hasAttr("colspan")) {
            try {
                colspan = Integer.parseInt(cell.attr("colspan"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return colspan;
    }
}

