/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.api.json.JSONObject;
import com.overzealous.remark.convert.DocumentConverter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.XmlDeclaration;

public class ProvenanceWriter
extends BufferedWriter {
    String _HTMLFileName = "unknown";
    String _MarkdownFileName = "unknown";
    boolean needsComma = false;

    public ProvenanceWriter(String inputFileName, String outputFileName, JSONObject HTMLFilters, String baseURI, String domain, Writer out) throws IOException {
        this(inputFileName, outputFileName, HTMLFilters, baseURI, domain, out, 4096);
    }

    public ProvenanceWriter(String inputFileName, String outputFileName, JSONObject HTMLFilters, String baseURI, String domain, Writer out, int sz) throws IOException {
        super(out, sz);
        if (baseURI == null) {
            baseURI = "";
        }
        if (domain == null) {
            domain = "";
        }
        Boolean seekHeaders = true;
        this._HTMLFileName = inputFileName;
        this._MarkdownFileName = outputFileName;
        JSONObject fileData = new JSONObject();
        fileData.put("inputFilename", (Object)inputFileName);
        fileData.put("outputFilename", (Object)outputFileName);
        if (baseURI != null) {
            fileData.put("baseURI", (Object)baseURI);
        }
        JSONObject specificHtmlFilters = new JSONObject();
        if (HTMLFilters != null && HTMLFilters.size() > 0) {
            specificHtmlFilters.put(DocumentConverter.DEFAULT_DOMAIN, (Object)((JSONObject)HTMLFilters.get(DocumentConverter.DEFAULT_DOMAIN)));
            JSONObject domainFilters = (JSONObject)HTMLFilters.get(domain);
            if (domainFilters == null) {
                domainFilters = new JSONObject();
                domainFilters.put(DocumentConverter.SEEK_HEADERS, (Object)seekHeaders);
            }
            if ((seekHeaders = (Boolean)domainFilters.get(DocumentConverter.SEEK_HEADERS)) == null) {
                seekHeaders = Boolean.TRUE;
                domainFilters.put(DocumentConverter.SEEK_HEADERS, (Object)seekHeaders);
            }
            specificHtmlFilters.put(domain, (Object)domainFilters);
            fileData.put("HTMLFilters", (Object)specificHtmlFilters);
        }
        String serialStart = fileData.serialize(true);
        serialStart = serialStart.substring(0, serialStart.length() - 2);
        this.write(serialStart);
        if (Boolean.TRUE.equals(seekHeaders)) {
            this.write(",\n   \"provenanceReminder\": \"seekHeaders is TRUE so markdown is filtered until the first header is encountered.\"");
        } else {
            this.write(",\n   \"provenanceReminder\": \"seekHeaders is FALSE so all generated markdown is available.\"");
        }
        this.write(",\n   \"provenance\": [\n");
        this.flush();
    }

    @Override
    public void close() throws IOException {
        this.write("\n   ]\n}\n");
        this.flush();
        super.close();
    }

    public void saveHTML2MD(String level, Node node, String markdown) throws IOException {
        if (markdown == null || markdown.trim().length() == 0) {
            return;
        }
        String nodeHTML = "";
        if (node instanceof Element) {
            nodeHTML = ((Element)node).shallowClone().toString();
        } else if (node instanceof TextNode) {
            nodeHTML = ((TextNode)node).parentNode().toString();
        } else if (node instanceof DocumentType) {
            nodeHTML = ((DocumentType)node).shallowClone().toString();
        } else if (node instanceof Comment) {
            nodeHTML = ((Comment)node).shallowClone().toString();
        } else if (node instanceof DataNode) {
            nodeHTML = ((DataNode)node).shallowClone().toString();
        } else if (node instanceof XmlDeclaration) {
            nodeHTML = ((XmlDeclaration)node).shallowClone().toString();
        }
        JSONObject provenance = new JSONObject();
        provenance.put("level", (Object)level);
        provenance.put("html", (Object)nodeHTML);
        provenance.put("md", (Object)markdown);
        if (this.needsComma) {
            this.write(",\n");
        } else {
            this.write("\n");
            this.needsComma = true;
        }
        this.write(provenance.serialize(true));
        this.flush();
    }

    public void saveFilteredHTML(String level, Node node, String filterReason) throws IOException {
        if (filterReason == null || filterReason.trim().length() == 0) {
            return;
        }
        String nodeHTML = "";
        if (node instanceof Element) {
            nodeHTML = ((Element)node).shallowClone().toString();
        } else if (node instanceof TextNode) {
            nodeHTML = ((TextNode)node).parentNode().toString();
        } else if (node instanceof DocumentType) {
            nodeHTML = ((DocumentType)node).shallowClone().toString();
        } else if (node instanceof Comment) {
            nodeHTML = ((Comment)node).shallowClone().toString();
        } else if (node instanceof DataNode) {
            nodeHTML = ((DataNode)node).shallowClone().toString();
        } else if (node instanceof XmlDeclaration) {
            nodeHTML = ((XmlDeclaration)node).shallowClone().toString();
        }
        JSONObject provenance = new JSONObject();
        provenance.put("level", (Object)level);
        provenance.put("html", (Object)nodeHTML);
        provenance.put("md", (Object)"");
        provenance.put("filterReason", (Object)filterReason);
        if (this.needsComma) {
            this.write(",\n");
        } else {
            this.write("\n");
            this.needsComma = true;
        }
        this.write(provenance.serialize(true));
        this.flush();
    }

    public void saveMD2Text(String level, String markdown, String text) throws IOException {
        if (text == null || text.trim().length() == 0) {
            return;
        }
        JSONObject provenance = new JSONObject();
        provenance.put("level", (Object)level);
        provenance.put("md", (Object)markdown);
        provenance.put("text", (Object)text);
        if (this.needsComma) {
            this.write(",\n");
        } else {
            this.write("\n");
            this.needsComma = true;
        }
        this.write(provenance.serialize(true));
        this.flush();
    }

    public void saveText2Cond(String level, String text, String conditional) throws IOException {
        if (conditional == null || conditional.trim().length() == 0) {
            return;
        }
        JSONObject provenance = new JSONObject();
        provenance.put("level", (Object)level);
        provenance.put("text", (Object)text);
        provenance.put("conditional", (Object)conditional);
        if (this.needsComma) {
            this.write(",\n");
        } else {
            this.write("\n");
            this.needsComma = true;
        }
        this.write(provenance.serialize(true));
        this.flush();
    }

    public static void main(String[] args) {
    }
}

