/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.convert.ProvenanceWriter;
import com.overzealous.remark.util.BlockWriter;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class List
extends AbstractNodeHandler {
    @Override
    public Node handleNode(NodeHandler parent, Element node, DocumentConverter converter, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel) {
        Node result = null;
        boolean first = true;
        boolean numericList = node.tagName().equals("ol");
        int listCounter = 1;
        BlockWriter parentWriter = converter.output;
        parentWriter.startBlock();
        int depthLevel = 0;
        String nextLevel = level + ".";
        for (Element child : node.children()) {
            if (searchLevel != null && searchLevel.equals(nextLevel + ++depthLevel)) {
                return child;
            }
            String md = "";
            if (first) {
                first = false;
            } else {
                parentWriter.println();
            }
            if (child.tag() != null && child.tagName().equals("br")) {
                if (converter.options.hardwraps) {
                    // empty if block
                }
            } else if (numericList) {
                md = md + listCounter + ". ";
                if (listCounter < 10) {
                    md = md + " ";
                }
                parentWriter.print(md);
                this.saveAnnotation(pw, level, node, md);
            } else {
                parentWriter.print(" *  ");
                this.saveAnnotation(pw, level, node, " *  ");
            }
            converter.output = new BlockWriter(parentWriter);
            converter.output.setPrependNewlineString("    ", true);
            result = converter.walkNodes(this, child, converter.blockNodes, pw, baseUri, domain, nextLevel + depthLevel, searchLevel);
            if (result != null) {
                return result;
            }
            if (child.tag() != null && child.tagName().equals("br")) continue;
            ++listCounter;
        }
        parentWriter.endBlock();
        converter.output = parentWriter;
        return result;
    }
}

