/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.Options;
import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.convert.ProvenanceWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class InlineStyle
extends AbstractNodeHandler {
    private static final char ITALICS_WRAPPER = '*';
    private static final String BOLD_WRAPPER = "**";
    private static final Pattern ITALICS_PATTERN = Pattern.compile("font-style:\\s*italic", 2);
    private static final Pattern BOLD_PATTERN = Pattern.compile("font-weight:\\s*bold", 2);
    private static final Pattern INWORD_CHARACTER = Pattern.compile("\\w");
    private static final Pattern SPACE_CONTENT_SPACE = Pattern.compile("^(\\s*+)(.*?)(\\s*)$", 32);
    private int italicDepth = 0;
    private int boldDepth = 0;

    @Override
    public Node handleNode(NodeHandler parent, Element node, DocumentConverter converter, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel) {
        Node result = null;
        String tag = node.tagName();
        if ("span".equals(tag)) {
            if (node.hasAttr("role") && node.attr("role").trim().length() > 0) {
                String nodeStr = node.toString().trim();
                int index = nodeStr.indexOf(">");
                nodeStr = nodeStr.substring(0, index).trim();
                converter.output.write("<!-- " + nodeStr + "> -->");
            } else {
                converter.output.testNewBlock();
                if (!converter.output.isAtLineStart()) {
                    converter.output.write(" ");
                }
            }
        }
        if (this.checkInnerBlock(node, pw, level)) {
            result = converter.walkNodes(parent, node, pw, baseUri, domain, level, searchLevel);
        } else {
            Rules rules = this.checkInword(node, converter, pw, level);
            if (rules.emphasisPreserved) {
                this.checkTag(node, rules, pw, level);
                result = rules.bold || rules.italics ? this.handleStyled(parent, node, converter, rules, pw, baseUri, domain, level, searchLevel) : converter.walkNodes(this, node, converter.inlineNodes, pw, baseUri, domain, level, searchLevel);
            } else {
                ++this.italicDepth;
                ++this.boldDepth;
                result = converter.walkNodes(this, node, converter.inlineNodes, pw, baseUri, domain, level, searchLevel);
                --this.italicDepth;
                --this.boldDepth;
            }
        }
        return result;
    }

    @Override
    public void handleTextNode(TextNode node, DocumentConverter converter, ProvenanceWriter aw, String baseUri, String domain, String level) {
        if (node.previousSibling() != null && node.nextSibling() != null || node.text().trim().length() != 0) {
            super.handleTextNode(node, converter, aw, baseUri, domain, level);
        }
    }

    private Node handleStyled(NodeHandler parent, Element node, DocumentConverter converter, Rules rules, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel) {
        Matcher parts;
        Node result = null;
        if (rules.bold) {
            ++this.boldDepth;
        }
        if (rules.italics) {
            ++this.italicDepth;
        }
        HashSet<Node> nodeSet = new HashSet<Node>();
        String content = converter.getInlineContent(this, node, true, pw, baseUri, domain, level, searchLevel, nodeSet);
        if (nodeSet.size() > 0) {
            result = (Node)nodeSet.iterator().next();
            return result;
        }
        if (rules.bold) {
            --this.boldDepth;
        }
        if (rules.italics) {
            --this.italicDepth;
        }
        if (content.length() > 0 && (parts = SPACE_CONTENT_SPACE.matcher(content)).find()) {
            String md = parts.group(1);
            if (parts.group(2).length() > 0) {
                md = md + this.start(rules, parts.group(1), converter, pw, level);
                md = md + parts.group(2);
                md = md + this.end(rules, parts.group(3), converter, pw, level);
            }
            md = md + parts.group(3);
            converter.output.write(md);
            this.saveAnnotation(pw, level, node, md);
        }
        return result;
    }

    private boolean checkInnerBlock(Element node, ProvenanceWriter aw, String level) {
        Element child;
        boolean blockExists = false;
        Iterator iterator = node.children().iterator();
        while (iterator.hasNext() && !(blockExists = (child = (Element)iterator.next()).isBlock() || this.checkInnerBlock(child, aw, level))) {
        }
        return blockExists;
    }

    private Rules checkInword(Element node, DocumentConverter converter, ProvenanceWriter aw, String level) {
        Rules result = new Rules();
        Options.InWordEmphasis iwe = converter.options.getInWordEmphasis();
        if (!iwe.isEmphasisPreserved() || iwe.isAdditionalSpacingNeeded()) {
            TextNode tn;
            String text;
            Node n = node.previousSibling();
            if (n != null && n instanceof TextNode && INWORD_CHARACTER.matcher((text = (tn = (TextNode)n).text()).substring(text.length() - 1)).matches()) {
                result.emphasisPreserved = iwe.isEmphasisPreserved();
                result.addSpacing = iwe.isAdditionalSpacingNeeded();
            }
            if ((n = node.nextSibling()) != null && n instanceof TextNode && INWORD_CHARACTER.matcher((tn = (TextNode)n).text().substring(0, 1)).matches()) {
                result.emphasisPreserved = iwe.isEmphasisPreserved();
                result.addSpacing = iwe.isAdditionalSpacingNeeded();
            }
        }
        return result;
    }

    private void checkTag(Element node, Rules rules, ProvenanceWriter aw, String level) {
        String tn = node.tagName();
        if (tn.equals("i") || tn.equals("em")) {
            rules.italics = this.italicDepth == 0;
        } else if (tn.equals("b") || tn.equals("strong")) {
            rules.bold = this.boldDepth == 0;
        } else if (node.hasAttr("style")) {
            String style = node.attr("style");
            if (ITALICS_PATTERN.matcher(style).find()) {
                boolean bl = rules.italics = this.italicDepth == 0;
            }
            if (BOLD_PATTERN.matcher(style).find()) {
                rules.bold = this.boldDepth == 0;
            }
        }
    }

    private String start(Rules style, String leadingSpaces, DocumentConverter converter, ProvenanceWriter aw, String level) {
        String md = "";
        if (!(!style.addSpacing || this.italicDepth != 0 && this.boldDepth != 0 || leadingSpaces != null && leadingSpaces.length() != 0)) {
            md = md + " ";
        }
        if (style.italics && this.italicDepth == 0) {
            md = md + '*';
        }
        if (style.bold && this.boldDepth == 0) {
            md = md + BOLD_WRAPPER;
        }
        return md;
    }

    private String end(Rules style, String trailingSpaces, DocumentConverter converter, ProvenanceWriter aw, String level) {
        String md = "";
        if (style.bold && this.boldDepth == 0) {
            md = md + BOLD_WRAPPER;
        }
        if (style.italics && this.italicDepth == 0) {
            md = md + '*';
        }
        if (!(!style.addSpacing || this.italicDepth != 0 && this.boldDepth != 0 || trailingSpaces != null && trailingSpaces.length() != 0)) {
            md = md + " ";
        }
        return md;
    }

    private class Rules {
        boolean emphasisPreserved = true;
        boolean addSpacing = false;
        boolean italics = false;
        boolean bold = false;

        private Rules() {
        }
    }
}

