/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.convert.ProvenanceWriter;
import com.overzealous.remark.util.BlockWriter;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class Image
extends AbstractNodeHandler {
    @Override
    public Node handleNode(NodeHandler parent, Element node, DocumentConverter converter, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel) {
        String alt;
        Node result = null;
        String url = node.attr("src");
        if (url.startsWith("//")) {
            url = this.getProtocol(baseUri) + url;
        } else if (url.startsWith("#") || url.startsWith("/")) {
            url = baseUri + url;
        }
        url = converter.cleaner.cleanUrl(url);
        if (node.attr("data-src").length() != 0) {
            url = node.attr("data-src");
            if (url.startsWith("//")) {
                url = this.getProtocol(baseUri) + url;
            } else if (url.startsWith("#") || url.startsWith("/")) {
                url = baseUri + url;
            }
            url = converter.cleaner.cleanUrl(url);
        }
        if (((alt = node.attr("alt")) == null || alt.trim().length() == 0) && (alt = node.attr("title")) == null) {
            alt = "";
        }
        alt = converter.cleaner.clean(alt.trim());
        if (converter.options.inlineLinks) {
            if (alt.length() == 0) {
                alt = "Image";
            }
            String md = String.format("![%s](%s)", alt, url);
            converter.output.print(md);
            this.saveAnnotation(pw, level, node, md);
        } else {
            String linkId = converter.addLink(url, alt, true);
            if (alt.length() == 0) {
                alt = linkId;
            }
            BlockWriter out = converter.output;
            if (alt.equals(linkId)) {
                String md = String.format("![%s][]", linkId);
                out.print(md);
                this.saveAnnotation(pw, level, node, md);
            } else {
                String md = String.format("![%s][%s]", alt, linkId);
                out.print(md);
                this.saveAnnotation(pw, level, node, md);
            }
        }
        return result;
    }

    String getProtocol(String url) {
        int index = url.indexOf(":");
        if (index > 0) {
            return url.substring(0, index) + ":";
        }
        return "http:";
    }
}

