/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.convert.ProvenanceWriter;
import com.overzealous.remark.util.BlockWriter;
import com.overzealous.remark.util.StringUtils;
import java.util.HashSet;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class Heading
extends AbstractNodeHandler {
    @Override
    public Node handleNode(NodeHandler parent, Element node, DocumentConverter converter, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel) {
        Node result = null;
        int depth = Integer.parseInt(node.tagName().substring(1, 2));
        HashSet<Node> nodeSet = new HashSet<Node>();
        String inlineContent = converter.getInlineContent(this, node, pw, baseUri, domain, level, searchLevel, nodeSet).replace("\n", " ");
        if (nodeSet.size() != 0) {
            result = (Node)nodeSet.iterator().next();
        }
        if (inlineContent.trim().length() == 0) {
            return result;
        }
        BlockWriter out = converter.output;
        out.startBlock();
        String md = StringUtils.multiply('#', depth) + " " + inlineContent + " " + StringUtils.multiply('#', depth);
        if (converter.options.headerIds && node.hasAttr("id")) {
            md = md + String.format("    {#%s}", node.attr("id"));
            out.print(md);
            this.saveAnnotation(pw, level, node, md);
        } else {
            out.print(md);
            this.saveAnnotation(pw, level, node, md);
        }
        out.endBlock();
        return result;
    }
}

