/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.api.json.JSONArray;
import com.api.json.JSONObject;
import com.overzealous.remark.IgnoredHtmlElement;
import com.overzealous.remark.Options;
import com.overzealous.remark.convert.Abbr;
import com.overzealous.remark.convert.Anchor;
import com.overzealous.remark.convert.Article;
import com.overzealous.remark.convert.Aside;
import com.overzealous.remark.convert.BlockQuote;
import com.overzealous.remark.convert.Break;
import com.overzealous.remark.convert.Button;
import com.overzealous.remark.convert.Codeblock;
import com.overzealous.remark.convert.DefaultNodeHandler;
import com.overzealous.remark.convert.Definitions;
import com.overzealous.remark.convert.Header;
import com.overzealous.remark.convert.Heading;
import com.overzealous.remark.convert.HorizontalRule;
import com.overzealous.remark.convert.Image;
import com.overzealous.remark.convert.InlineCode;
import com.overzealous.remark.convert.InlineStyle;
import com.overzealous.remark.convert.Input;
import com.overzealous.remark.convert.List;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.convert.NodeRemover;
import com.overzealous.remark.convert.Paragraph;
import com.overzealous.remark.convert.ProvenanceWriter;
import com.overzealous.remark.convert.SVG;
import com.overzealous.remark.convert.Span;
import com.overzealous.remark.convert.Table;
import com.overzealous.remark.convert.TextArea;
import com.overzealous.remark.convert.TextCleaner;
import com.overzealous.remark.util.BlockWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class DocumentConverter {
    public static String DEFAULT_DOMAIN = "*";
    public static String ALL_TAGS = ":all";
    public static String TAG_NAMES = ":tagnames";
    public static String SEEK_HEADERS = ":seek_headers";
    public static String OVERRIDE_RULES = ":overrides";
    final Options options;
    protected final TextCleaner cleaner;
    protected final Set<String> ignoredHtmlTags;
    protected final Map<String, NodeHandler> blockNodes;
    protected final Map<String, NodeHandler> inlineNodes;
    protected JSONObject HTMLFilters = new JSONObject();
    protected Map<String, String> linkUrls;
    protected int genericLinkUrlCounter;
    protected int genericImageUrlCounter;
    protected Map<String, String> linkIds;
    protected Map<String, String> abbreviations;
    protected BlockWriter output = null;
    protected Map<String, NodeHandler> lastNodeset;
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern LINK_MULTIPLE_SPACES = Pattern.compile(" {2,}", 32);
    private static final Pattern LINK_SAFE_CHARS = Pattern.compile("[^-\\w \\.]+", 32);
    private static final String LINK_REPLACEMENT = "_";
    private static final Pattern LINK_EDGE_REPLACE = Pattern.compile(String.format("(^%1$s++)|(%1$s++$)", "_"));
    private static final Pattern LINK_MULTIPLE_REPLACE = Pattern.compile(String.format("%1$s{2,}", "_"));
    private static final Pattern LINK_FILENAME = Pattern.compile("/([^/]++)$");

    public DocumentConverter(Options options) {
        this(options, null);
    }

    public DocumentConverter(Options options, JSONObject HTMLFilters) {
        this.options = options;
        this.cleaner = new TextCleaner(options);
        this.ignoredHtmlTags = new HashSet<String>();
        this.blockNodes = new HashMap<String, NodeHandler>();
        this.inlineNodes = new HashMap<String, NodeHandler>();
        if (HTMLFilters != null) {
            this.HTMLFilters = HTMLFilters;
        }
        for (IgnoredHtmlElement ihe : options.getIgnoredHtmlElements()) {
            this.ignoredHtmlTags.add(ihe.getTagName());
        }
        this.configureNodes();
    }

    private void configureNodes() {
        this.addInlineNode(new InlineStyle(), "i,em,b,strong,font,span");
        this.addInlineNode(new InlineCode(), "code,tt");
        this.addInlineNode(new Image(), "img");
        this.addInlineNode(new Anchor(), "a");
        this.addInlineNode(new Break(), "br");
        this.addInlineNode(new Button(), "button");
        this.addInlineNode(new Input(), "input");
        this.addBlockNode(new Aside(), "aside");
        this.addBlockNode(new Heading(), "h1,h2,h3,h4,h5,h6");
        this.addBlockNode(new Header(), "header");
        this.addBlockNode(new Paragraph(), "p");
        this.addBlockNode(new Codeblock(), "pre");
        this.addBlockNode(new BlockQuote(), "blockquote");
        this.addBlockNode(new Button(), "button");
        this.addBlockNode(new Span(), "span");
        this.addBlockNode(new SVG(), "svg");
        this.addBlockNode(new HorizontalRule(), "hr");
        this.addBlockNode(new List(), "ol,ul");
        this.addBlockNode(new Input(), "input");
        this.addBlockNode(new Article(), "article");
        this.addBlockNode(new TextArea(), "textarea");
        if (this.options.abbreviations) {
            this.addInlineNode(new Abbr(), "abbr,acronym");
        }
        if (this.options.definitionLists) {
            this.addBlockNode(new Definitions(), "dl");
        }
        if (this.options.getTables().isConvertedToText()) {
            this.addBlockNode(new Table(), "table");
        } else if (this.options.getTables().isRemoved()) {
            this.addBlockNode(NodeRemover.getInstance(), "table");
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public TextCleaner getCleaner() {
        return this.cleaner;
    }

    public Map<String, NodeHandler> getBlockNodes() {
        return Collections.unmodifiableMap(this.blockNodes);
    }

    public Map<String, NodeHandler> getInlineNodes() {
        return Collections.unmodifiableMap(this.inlineNodes);
    }

    public BlockWriter getOutput() {
        return this.output;
    }

    public void setOutput(BlockWriter output) {
        this.output = output;
    }

    public void addInlineNode(NodeHandler handler, String tagnames) {
        for (String key : COMMA.split(tagnames)) {
            if (key.length() <= 0) continue;
            this.inlineNodes.put(key, handler);
            this.blockNodes.put(key, handler);
        }
    }

    public void addBlockNode(NodeHandler handler, String tagnames) {
        for (String key : COMMA.split(tagnames)) {
            if (key.length() <= 0) continue;
            this.blockNodes.put(key, handler);
        }
    }

    public void convert(Document doc, Writer out, ProvenanceWriter pw, String baseUri, String domain) {
        this.output = new BlockWriter(out, true);
        this.convertImpl(doc, pw, baseUri, domain);
    }

    public void convert(Document doc, OutputStream out, ProvenanceWriter pw, String baseUri, String domain) {
        this.output = new BlockWriter(out, true);
        this.convertImpl(doc, pw, baseUri, domain);
    }

    public String convert(Document doc, ProvenanceWriter pw, String baseUri, String domain) {
        BlockWriter bw;
        this.output = bw = BlockWriter.create(DocumentConverter.calculateLength(doc, 0));
        this.convertImpl(doc, pw, baseUri, domain);
        return bw.toString();
    }

    public static int calculateLength(Element el, int depth) {
        int result = 0;
        for (Node n : el.childNodes()) {
            if (n instanceof Element) {
                result += 4 * depth + DocumentConverter.calculateLength((Element)n, depth + 1);
                continue;
            }
            if (!(n instanceof TextNode)) continue;
            result += ((TextNode)n).text().length();
        }
        return result;
    }

    private void convertImpl(Document doc, ProvenanceWriter pw, String baseUri, String domain) {
        this.linkIds = new LinkedHashMap<String, String>();
        this.linkUrls = new HashMap<String, String>();
        this.genericImageUrlCounter = 0;
        this.genericLinkUrlCounter = 0;
        this.abbreviations = new LinkedHashMap<String, String>();
        this.lastNodeset = this.blockNodes;
        String level = "1";
        Element body = doc.body();
        try {
            if (pw != null) {
                pw.saveHTML2MD(level, body, "");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.walkNodes(DefaultNodeHandler.getInstance(), body, this.blockNodes, pw, baseUri, domain, level, null);
        if (!this.linkIds.isEmpty()) {
            this.output.startBlock();
            for (Map.Entry<String, String> link : this.linkIds.entrySet()) {
                this.output.printf("\n[%s]: %s", link.getKey(), link.getValue());
            }
            this.output.endBlock();
        }
        if (!this.abbreviations.isEmpty()) {
            this.output.startBlock();
            for (Map.Entry<String, String> abbr : this.abbreviations.entrySet()) {
                this.output.printf("\n*[%s]: %s", abbr.getKey(), this.cleaner.clean(abbr.getValue()));
            }
            this.output.endBlock();
        }
        this.linkIds = null;
        this.linkUrls = null;
        this.abbreviations = null;
    }

    public Node walkNodes(NodeHandler currentNode, Element el, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel) {
        return this.walkNodes(currentNode, el, this.lastNodeset, pw, baseUri, domain, level, searchLevel);
    }

    public Node walkNodes(NodeHandler currentNodeHandler, Element el, Map<String, NodeHandler> nodeList, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel) {
        Node result = null;
        Map<String, NodeHandler> backupLastNodeset = this.lastNodeset;
        this.lastNodeset = nodeList;
        int depthLevel = 0;
        int textLevel = 0;
        String nextLevel = "";
        for (Node n : el.childNodes()) {
            if (n instanceof TextNode && " ".equals(n.toString())) continue;
            if (n instanceof TextNode) {
                if (searchLevel != null && searchLevel.equals(level + "^" + ++textLevel)) {
                    return n;
                }
                currentNodeHandler.handleTextNode((TextNode)n, this, pw, baseUri, domain, level + "^" + textLevel);
                continue;
            }
            nextLevel = level + "." + ++depthLevel;
            if (searchLevel != null && searchLevel.equals(nextLevel)) {
                return n;
            }
            if (n instanceof Element) {
                Element node = (Element)n;
                String tagName = node.tagName();
                if (DocumentConverter.checkHTMLFilters(this.HTMLFilters, tagName, node, pw, baseUri, domain, nextLevel)) continue;
                if (nodeList.containsKey(tagName)) {
                    result = nodeList.get(tagName).handleNode(currentNodeHandler, node, this, pw, baseUri, domain, nextLevel, searchLevel);
                    if (result == null) continue;
                    return result;
                }
                if (this.ignoredHtmlTags.contains(tagName)) {
                    currentNodeHandler.handleIgnoredHTMLElement(node, this, pw, baseUri, domain, nextLevel);
                    continue;
                }
                if (node.isBlock()) {
                    this.output.startBlock();
                }
                try {
                    if (pw != null) {
                        pw.saveFilteredHTML(nextLevel, node, "tag: \"" + tagName + "\" has no specific processing so reviewing its children.");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                result = this.walkNodes(currentNodeHandler, node, nodeList, pw, baseUri, domain, nextLevel, searchLevel);
                if (result != null) {
                    return result;
                }
                if (!node.isBlock()) continue;
                this.output.endBlock();
                continue;
            }
            try {
                if (pw == null) continue;
                pw.saveFilteredHTML(nextLevel, n, "type: \"" + n.getClass().getSimpleName() + "\" is not a type we care about");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.lastNodeset = backupLastNodeset;
        return result;
    }

    public static boolean checkHTMLFilters(JSONObject HTMLFilters, String nodeTagName, Element node, ProvenanceWriter pw, String baseUri, String domain, String level) {
        JSONArray tagNames;
        JSONObject generalRules;
        JSONObject domainRules = new JSONObject();
        JSONObject overrideRules = new JSONObject();
        JSONArray overrideTagNames = new JSONArray();
        JSONObject noOverrides = new JSONObject();
        Cloneable artifact = null;
        if (domain != null && (domainRules = (JSONObject)HTMLFilters.get(domain)) != null) {
            artifact = (JSONObject)domainRules.get(OVERRIDE_RULES);
            if (artifact != null) {
                overrideRules = artifact;
            }
            if ((artifact = (JSONArray)overrideRules.get(TAG_NAMES)) != null) {
                overrideTagNames = (JSONArray)artifact;
            }
        }
        if ((generalRules = (JSONObject)HTMLFilters.get(DEFAULT_DOMAIN)) != null) {
            tagNames = (JSONArray)generalRules.get(TAG_NAMES);
            if (tagNames != null && !overrideTagNames.contains(node.tagName()) && tagNames.contains(node.tagName())) {
                try {
                    if (pw != null) {
                        pw.saveFilteredHTML(level, node, "tag: \"" + node.tagName() + "\" is contained in \"" + DEFAULT_DOMAIN + "~" + TAG_NAMES + "\"");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
            JSONObject allTagRules = (JSONObject)generalRules.get(ALL_TAGS);
            if (allTagRules != null && DocumentConverter.checkTagAttributeFilters(allTagRules, node, (JSONObject)overrideRules.get(ALL_TAGS), DEFAULT_DOMAIN + "~" + ALL_TAGS, pw, level)) {
                return true;
            }
            JSONObject nodeTagRules = (JSONObject)generalRules.get(nodeTagName);
            if (nodeTagRules != null && DocumentConverter.checkTagAttributeFilters(nodeTagRules, node, (JSONObject)overrideRules.get(nodeTagName), DEFAULT_DOMAIN + "~" + nodeTagName, pw, level)) {
                return true;
            }
        }
        if (domainRules != null) {
            tagNames = (JSONArray)domainRules.get(TAG_NAMES);
            if (tagNames != null && tagNames.contains(node.tagName())) {
                try {
                    if (pw != null) {
                        pw.saveFilteredHTML(level, node, "tag: \"" + node.tagName() + "\" is contained in \"" + domain + "~" + TAG_NAMES + "\"");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
            JSONObject allDomainTagRules = (JSONObject)domainRules.get(ALL_TAGS);
            if (allDomainTagRules != null && DocumentConverter.checkTagAttributeFilters(allDomainTagRules, node, noOverrides, domain + "~" + ALL_TAGS, pw, level)) {
                return true;
            }
            JSONObject domainNodeTagRules = (JSONObject)domainRules.get(nodeTagName);
            if (domainNodeTagRules != null && DocumentConverter.checkTagAttributeFilters(domainNodeTagRules, node, noOverrides, domain + "~" + nodeTagName, pw, level)) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkTagAttributeFilters(JSONObject tagAttributeFilters, Element node, JSONObject overrides, String filterType, ProvenanceWriter pw, String level) {
        String testValue = "";
        String filter = "";
        HashSet<String> overrideFilterValues = new HashSet<String>();
        Set attributes = tagAttributeFilters.keySet();
        boolean allowOverride = false;
        if (overrides == null) {
            overrides = new JSONObject();
        }
        for (String attribute : attributes) {
            if (attribute.equals(SEEK_HEADERS)) continue;
            JSONArray overrideFilters = (JSONArray)overrides.get(attribute);
            if (overrideFilters == null) {
                overrideFilters = new JSONArray();
            }
            overrideFilterValues = new HashSet();
            for (Object ovObj : overrideFilters) {
                overrideFilterValues.add(ovObj.toString());
            }
            JSONArray filters = (JSONArray)tagAttributeFilters.get(attribute);
            if (filters == null || (testValue = node.attr(attribute).toLowerCase()).length() == 0) continue;
            for (Object filterObj : filters) {
                filter = filterObj.toString();
                if (!testValue.contains(filter)) continue;
                allowOverride = false;
                for (String ovFilter : overrideFilterValues) {
                    if (!ovFilter.contains(filter)) continue;
                    allowOverride = true;
                    break;
                }
                if (allowOverride) continue;
                try {
                    if (pw != null) {
                        pw.saveFilteredHTML(level, node, "attribute: \"" + attribute + "\" value: \"" + testValue + "\" contains filter: \"" + filterType + "~" + attribute + "~" + filter + "\"");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    public String getInlineContent(NodeHandler currentNode, Element el, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel, Set<Node> foundNodes) {
        return this.getInlineContent(currentNode, el, false, pw, baseUri, domain, level, searchLevel, foundNodes);
    }

    public String getInlineContent(NodeHandler currentNode, Element el, boolean undoLeadingEscapes, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel, Set<Node> foundNodes) {
        BlockWriter oldOutput = this.output;
        this.output = BlockWriter.create(1000);
        Node result = this.walkNodes(currentNode, el, this.inlineNodes, pw, baseUri, domain, level, searchLevel);
        if (result != null) {
            foundNodes.add(result);
        }
        String ret = this.output.toString();
        this.output = oldOutput;
        if (undoLeadingEscapes) {
            ret = this.cleaner.unescapeLeadingCharacters(ret);
        }
        return ret;
    }

    public String addLink(String url, String recommendedName, boolean image) {
        String linkId;
        int nlIndex = url.indexOf("\n");
        if (nlIndex > 0 && nlIndex < url.length() - 1) {
            String tmp = url.substring(0, nlIndex);
            url = tmp + url.substring(nlIndex + 1);
        }
        if (this.linkUrls.containsKey(url)) {
            linkId = this.linkUrls.get(url);
        } else {
            if (this.options.simpleLinkIds) {
                linkId = (image ? "image-" : "") + String.valueOf(this.linkUrls.size() + 1);
            } else {
                if (this.linkIds.containsKey(recommendedName = this.cleanLinkId(url, recommendedName, image))) {
                    int incr = 1;
                    while (this.linkIds.containsKey(String.format("%s %d", recommendedName, incr))) {
                        ++incr;
                    }
                    recommendedName = String.format("%s %d", recommendedName, incr);
                }
                linkId = recommendedName;
            }
            this.linkUrls.put(url, linkId);
            this.linkIds.put(linkId, url);
        }
        return linkId;
    }

    void addAbbreviation(String abbr, String definition) {
        if (!this.abbreviations.containsKey(abbr)) {
            this.abbreviations.put(abbr, definition);
        }
    }

    String cleanLinkId(String url, String linkId, boolean image) {
        String ret = linkId.replace('\n', ' ');
        ret = LINK_MULTIPLE_SPACES.matcher(ret).replaceAll(" ");
        ret = LINK_SAFE_CHARS.matcher(ret).replaceAll(LINK_REPLACEMENT);
        ret = LINK_MULTIPLE_REPLACE.matcher(ret).replaceAll(LINK_REPLACEMENT);
        ret = LINK_EDGE_REPLACE.matcher(ret).replaceAll("");
        if ((ret = ret.trim()).length() == 0 || ret.equals(LINK_REPLACEMENT)) {
            if (image) {
                if (url != null) {
                    Matcher m = LINK_FILENAME.matcher(url);
                    if (m.find()) {
                        ret = this.cleanLinkId(null, m.group(1), true);
                    } else {
                        ++this.genericImageUrlCounter;
                        ret = "Image " + this.genericImageUrlCounter;
                    }
                } else {
                    ++this.genericImageUrlCounter;
                    ret = "Image " + this.genericImageUrlCounter;
                }
            } else {
                ++this.genericLinkUrlCounter;
                ret = "Link " + this.genericLinkUrlCounter;
            }
        }
        return ret;
    }
}

