/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.convert.ProvenanceWriter;
import com.overzealous.remark.util.BlockWriter;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class Definitions
extends AbstractNodeHandler {
    @Override
    public Node handleNode(NodeHandler parent, Element node, DocumentConverter converter, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel) {
        Node result = null;
        boolean first = true;
        boolean lastNodeWasDD = false;
        BlockWriter parentWriter = converter.output;
        int textLevel = 0;
        String nextLevel = "";
        parentWriter.startBlock();
        for (Element child : node.children()) {
            nextLevel = level + "^" + ++textLevel;
            if (searchLevel != null && searchLevel.equals(nextLevel)) {
                return child;
            }
            if (child.tagName().equals("dt")) {
                if (first) {
                    first = false;
                } else {
                    parentWriter.endBlock();
                    parentWriter.startBlock();
                }
                result = converter.walkNodes(this, child, converter.inlineNodes, pw, baseUri, domain, nextLevel, searchLevel);
                parentWriter.println();
                lastNodeWasDD = false;
                continue;
            }
            if (!child.tagName().equals("dd")) continue;
            if (first) {
                first = false;
            }
            if (lastNodeWasDD) {
                parentWriter.println();
            }
            parentWriter.print(":   ");
            this.saveAnnotation(pw, level, child, ":   ");
            converter.output = new BlockWriter(parentWriter).setPrependNewlineString("    ", true);
            result = converter.walkNodes(this, child, converter.blockNodes, pw, baseUri, domain, nextLevel, searchLevel);
            converter.output = parentWriter;
            lastNodeWasDD = true;
        }
        parentWriter.endBlock();
        return result;
    }
}

