/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.Options;
import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.convert.ProvenanceWriter;
import com.overzealous.remark.util.BlockWriter;
import com.overzealous.remark.util.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class Codeblock
extends AbstractNodeHandler {
    @Override
    public Node handleNode(NodeHandler parent, Element node, DocumentConverter converter, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel) {
        Node result = null;
        Options.FencedCodeBlocks fenced = converter.options.getFencedCodeBlocks();
        if (fenced.isEnabled()) {
            String fence = StringUtils.multiply(fenced.getSeparatorCharacter(), converter.options.fencedCodeBlocksWidth);
            BlockWriter out = converter.output;
            converter.output.startBlock();
            String md = fence + "\n" + converter.cleaner.cleanCode(node) + "\n" + fence;
            out.print(md);
            this.saveAnnotation(pw, level, node, md);
            converter.output.endBlock();
        } else {
            converter.output.startBlock();
            BlockWriter out = new BlockWriter(converter.output).setPrependNewlineString("    ");
            String md = converter.cleaner.cleanCode(node);
            out.write(md);
            this.saveAnnotation(pw, level, node, md);
            converter.output.endBlock();
        }
        return result;
    }
}

