/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.convert.ProvenanceWriter;
import java.util.HashSet;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class Anchor
extends AbstractNodeHandler {
    @Override
    public Node handleNode(NodeHandler parent, Element node, DocumentConverter converter, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel) {
        Node result = null;
        if (node.hasAttr("href") && node.attr("href").trim().length() > 0) {
            String url = node.attr("href");
            if (url.startsWith("#") || url.startsWith("/")) {
                url = baseUri + url;
            }
            url = converter.cleaner.cleanUrl(url);
            HashSet<Node> foundNodes = new HashSet<Node>();
            String label = converter.getInlineContent(this, node, pw, baseUri, domain, level, searchLevel, foundNodes);
            if (foundNodes.size() > 0) {
                return foundNodes.toArray(new Node[0])[0];
            }
            if (label.length() > 0) {
                if (converter.options.autoLinks && url.equals(label)) {
                    converter.output.write(label);
                    this.saveAnnotation(pw, level, node, label);
                } else if (converter.options.inlineLinks) {
                    if (converter.options.fixPegdownStrongEmphasisInLinks) {
                        label = label.replace("***", "**");
                    }
                    String md = String.format("[%s](%s)", label, url);
                    converter.output.print(md);
                    this.saveAnnotation(pw, level, node, md);
                } else {
                    String linkId;
                    if (converter.options.fixPegdownStrongEmphasisInLinks) {
                        label = label.replace("***", "**");
                    }
                    if (label.equals(linkId = converter.addLink(url, label, false))) {
                        String md = String.format("[%s][]", label);
                        converter.output.print(md);
                        this.saveAnnotation(pw, level, node, md);
                    } else {
                        String md = String.format("[%s][%s]", label, linkId);
                        converter.output.print(md);
                        this.saveAnnotation(pw, level, node, md);
                    }
                }
            }
        } else {
            converter.output.write(" ");
            result = converter.walkNodes(parent, node, pw, baseUri, domain, level, searchLevel);
            if (result != null) {
                return result;
            }
        }
        return null;
    }
}

