/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.convert.ProvenanceWriter;
import com.overzealous.remark.util.BlockWriter;
import java.io.IOException;
import java.util.Map;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public abstract class AbstractNodeHandler
implements NodeHandler {
    @Override
    public void handleTextNode(TextNode node, DocumentConverter converter, ProvenanceWriter pw, String baseUri, String domain, String level) {
        String md = converter.cleaner.clean(node);
        converter.output.write(md);
        this.saveAnnotation(pw, level, node, md);
    }

    @Override
    public void handleIgnoredHTMLElement(Element node, DocumentConverter converter, ProvenanceWriter pw, String baseUri, String domain, String level) {
        if (node.isBlock()) {
            converter.output.writeBlock(node.toString());
        } else {
            Document doc = node.ownerDocument();
            boolean oldPrettyPrint = doc.outputSettings().prettyPrint();
            doc.outputSettings().prettyPrint(false);
            converter.output.write(node.toString());
            String md = node.toString();
            this.saveAnnotation(pw, level, node, md);
            doc.outputSettings().prettyPrint(oldPrettyPrint);
        }
    }

    protected Node prependAndRecurse(String prepend, Element node, DocumentConverter converter, Map<String, NodeHandler> nodes, ProvenanceWriter pw, String baseUri, String domain, String level, String searchLevel) {
        Node result = null;
        BlockWriter oldOutput = converter.output;
        converter.output = new BlockWriter(oldOutput);
        converter.output.setPrependNewlineString(prepend);
        result = converter.walkNodes(this, node, nodes, pw, baseUri, domain, level, searchLevel);
        converter.output = oldOutput;
        return result;
    }

    protected void saveAnnotation(ProvenanceWriter pw, String level, Node node, String markdown) {
        if (pw != null) {
            try {
                pw.saveHTML2MD(level, node, markdown);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void saveFilterAnnotation(ProvenanceWriter pw, String level, Node node, String filterReason) {
        if (pw != null) {
            try {
                pw.saveFilteredHTML(level, node, filterReason);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

