/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark;

import com.api.json.JSON;
import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLUtils;
import com.overzealous.remark.IgnoredHtmlElement;
import com.overzealous.remark.Options;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.ProvenanceWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Whitelist;

public class Remark {
    public static String HTML_FILTER_FILENAME = "HTML_Filters.json";
    private Cleaner _cleaner;
    private final Options _options;
    private final DocumentConverter _converter;
    private final ReentrantLock _converterLock = new ReentrantLock();
    private boolean _cleanedHtmlEchoed = false;
    private JSONObject _HTMLFilters = new JSONObject();
    private Whitelist _whitelist = Whitelist.basicWithImages();

    public Remark() {
        this(Options.markdown());
    }

    public Remark(Options options) {
        this(options, null);
    }

    public Remark(JSONObject HTMLFilters) {
        this(Options.markdown(), HTMLFilters);
    }

    public Remark(Options options, JSONObject HTMLFilters) {
        this._options = options.getCopy();
        try {
            if (HTMLFilters != null) {
                this._HTMLFilters = (JSONObject)JSON.parse(HTMLFilters.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HTMLFilters = Remark.getHTMLFilters(HTMLFilters, DocumentConverter.DEFAULT_DOMAIN);
        this._cleaner = Remark.updateCleaner(DocumentConverter.DEFAULT_DOMAIN, this._options, HTMLFilters);
        this._whitelist = Remark.makeBaselineWhitelist(options);
        this._cleaner = new Cleaner(this._whitelist);
        if (options.getTables().isLeftAsHtml()) {
            options.getIgnoredHtmlElements().add(IgnoredHtmlElement.create("table", new String[0]));
        }
        this._converter = new DocumentConverter(options, HTMLFilters);
    }

    public static Whitelist makeBaselineWhitelist(Options options) {
        Whitelist whitelist = Whitelist.basicWithImages().addTags("div", "h1", "h2", "h3", "h4", "h5", "h6", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "hr", "span", "font", "header", "footer", "noscript", "form", "input", "section", "aside", "svg", "button", "article", "textarea").addAttributes("th", "colspan", "align", "style").addAttributes("td", "colspan", "align", "style").addAttributes("input", "value", "type", "placeholder").addAttributes("img", "data-src").addAttributes("nav", "role").addAttributes("svg", "style").addAttributes("button", "value").addAttributes(":all", "title", "style");
        if (options.preserveRelativeLinks) {
            whitelist.preserveRelativeLinks(true);
        }
        if (options.abbreviations) {
            whitelist.addTags("abbr", "acronym");
        }
        if (options.headerIds) {
            for (int i = 1; i <= 6; ++i) {
                whitelist.addAttributes("h" + i, "id");
            }
        }
        for (IgnoredHtmlElement el : options.getIgnoredHtmlElements()) {
            whitelist.addTags(el.getTagName());
            if (el.getAttributes().isEmpty()) continue;
            whitelist.addAttributes(el.getTagName(), el.getAttributes().toArray(new String[el.getAttributes().size()]));
        }
        return whitelist;
    }

    public static JSONObject getHTMLFilters(String filterFileName) {
        File testFile;
        JSONObject htmlFilters = new JSONObject();
        if (filterFileName == null) {
            filterFileName = HTML_FILTER_FILENAME;
        }
        if (!(testFile = new File(filterFileName)).exists()) {
            System.err.println("Filter file \"" + filterFileName + "\" does not exist. Using default \"" + HTML_FILTER_FILENAME + "\"");
            filterFileName = HTML_FILTER_FILENAME;
        } else if (testFile.isDirectory()) {
            System.err.println("Filter file \"" + filterFileName + "\" is a directory. Using default \"" + HTML_FILTER_FILENAME + "\"");
            filterFileName = HTML_FILTER_FILENAME;
        }
        try {
            htmlFilters = Remark.getHTMLFilters(MDfromHTMLUtils.loadJSONFile(filterFileName), DocumentConverter.DEFAULT_DOMAIN);
        }
        catch (Exception e) {
            System.err.println("Could not load the JSON content from the file \"" + filterFileName + "\" -- error: " + e.getLocalizedMessage());
            System.err.println("No HTML filtering will be performed.");
        }
        return htmlFilters;
    }

    public static JSONObject getHTMLFilters(JSONObject HTMLFilters, String domain) {
        if (HTMLFilters == null) {
            HTMLFilters = new JSONObject();
            HTMLFilters.put(DocumentConverter.DEFAULT_DOMAIN, (Object)new JSONObject());
        }
        return HTMLFilters;
    }

    public void resetCleaner() {
        this._cleaner = new Cleaner(this._whitelist);
    }

    public static Cleaner updateCleaner(String domain, Options options, JSONObject HTMLFilters) {
        JSONObject attributeObj;
        Set attributes;
        Set tags;
        Whitelist whitelist = Remark.makeBaselineWhitelist(options);
        JSONObject domainFilters = (JSONObject)HTMLFilters.get(DocumentConverter.DEFAULT_DOMAIN);
        if (domainFilters != null) {
            tags = domainFilters.keySet();
            whitelist.addTags(tags.toArray(new String[0]));
            for (String tag : tags) {
                if (DocumentConverter.TAG_NAMES.equals(tag) || DocumentConverter.SEEK_HEADERS.equals(tag) || (attributes = (attributeObj = (JSONObject)domainFilters.get(tag)).keySet()).size() == 0) continue;
                whitelist = whitelist.addAttributes(tag, attributes.toArray(new String[0]));
            }
        }
        if (domain != null && !DocumentConverter.DEFAULT_DOMAIN.equals(domain) && (domainFilters = (JSONObject)HTMLFilters.get(domain)) != null) {
            tags = domainFilters.keySet();
            whitelist.addTags(tags.toArray(new String[0]));
            for (String tag : tags) {
                if (DocumentConverter.TAG_NAMES.equals(tag) || DocumentConverter.SEEK_HEADERS.equals(tag)) continue;
                attributeObj = (JSONObject)domainFilters.get(tag);
                attributes = attributeObj.keySet();
                whitelist = whitelist.addAttributes(tag, attributes.toArray(new String[0]));
            }
        }
        return new Cleaner(whitelist);
    }

    public DocumentConverter getConverter() {
        return this._converter;
    }

    public boolean isCleanedHtmlEchoed() {
        return this._cleanedHtmlEchoed;
    }

    public void setCleanedHtmlEchoed(boolean cleanedHtmlEchoed) {
        this._cleanedHtmlEchoed = cleanedHtmlEchoed;
    }

    public void setHTMLFilters(JSONObject HTMLFilters) throws IOException {
        this._HTMLFilters = (JSONObject)JSON.parse(HTMLFilters.toString());
    }

    public synchronized Remark withAnnotationWriter(ProvenanceWriter aw) throws Exception {
        if (aw == null) {
            throw new NullPointerException("ProvenanceWriter cannot be null.");
        }
        return new StreamRemark(this, aw);
    }

    public synchronized Remark withWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("Writer cannot be null.");
        }
        return new StreamRemark(this, writer);
    }

    public synchronized Remark withOutputStream(OutputStream os) {
        if (os == null) {
            throw new NullPointerException("OutputStream cannot be null.");
        }
        return new StreamRemark(this, os);
    }

    public synchronized Remark withAnnotationWriter(ProvenanceWriter aw, JSONObject HTMLFilters) {
        if (aw == null) {
            throw new NullPointerException("ProvenanceWriter cannot be null.");
        }
        return new StreamRemark(this, aw, HTMLFilters);
    }

    public synchronized Remark withWriter(Writer writer, JSONObject HTMLFilters) {
        if (writer == null) {
            throw new NullPointerException("Writer cannot be null.");
        }
        return new StreamRemark(this, writer, HTMLFilters);
    }

    public synchronized Remark withOutputStream(OutputStream os, JSONObject HTMLFilters) {
        if (os == null) {
            throw new NullPointerException("OutputStream cannot be null.");
        }
        return new StreamRemark(this, os, HTMLFilters);
    }

    public String convert(URL url, int timeoutMillis) throws IOException {
        Document doc = Jsoup.parse(url, timeoutMillis);
        return this.convert(doc, url.toString());
    }

    public String convert(File file) throws IOException {
        return this.convert(file, null);
    }

    public String convert(File file, String charset) throws IOException {
        return this.convert(file, charset, "");
    }

    public String convert(File file, String charset, String baseUri) throws IOException {
        Document doc = Jsoup.parse(file, charset, baseUri);
        return this.convert(doc, baseUri);
    }

    public String convert(String html) {
        return this.convert(html, "");
    }

    public String convert(String html, String baseUri) {
        Document doc = Jsoup.parse(html, baseUri);
        return this.convert(doc, baseUri);
    }

    public String convertFragment(String body) {
        return this.convertFragment(body, "");
    }

    public String convertFragment(String body, String baseUri) {
        Document doc = Jsoup.parseBodyFragment(body, baseUri);
        return this.convert(doc, baseUri);
    }

    public String convert(Document doc, ProvenanceWriter aw) {
        return this.processConvert(doc, null, null, aw, null);
    }

    public String convert(Document doc, ProvenanceWriter aw, String baseUri) {
        return this.processConvert(doc, null, null, aw, baseUri);
    }

    public String convert(Document doc, String baseUri) {
        String markdown = this.processConvert(doc, null, null, null, baseUri);
        return markdown;
    }

    public static String getDomain(String baseUri) {
        String result = null;
        int index = -1;
        int index1 = -1;
        int index2 = -1;
        if (baseUri != null && (baseUri = baseUri.trim()).length() > 0) {
            index = baseUri.indexOf("//");
            if (index != -1 && baseUri.length() > index + 2) {
                baseUri = baseUri.substring(index + 2);
            }
            index1 = baseUri.indexOf("/");
            index2 = baseUri.indexOf(":");
            result = index1 != -1 && index2 != -1 ? (index1 < index2 ? baseUri.substring(0, index1) : baseUri.substring(0, index2)) : (index1 != -1 && index2 == -1 ? baseUri.substring(0, index1) : (index1 == -1 && index2 != -1 ? baseUri.substring(0, index2) : baseUri));
        }
        return result;
    }

    public JSONObject getHTMLFilters() {
        return this._HTMLFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processConvert(Document doc, Writer writer, OutputStream os, ProvenanceWriter aw, String baseURI) {
        String domain = Remark.getDomain(baseURI);
        int testindex = baseURI.indexOf(domain);
        String workingURI = baseURI.substring(testindex + domain.length());
        if ((testindex = workingURI.toLowerCase().indexOf("http")) >= 0) {
            workingURI = workingURI.substring(testindex);
            domain = Remark.getDomain(workingURI);
            baseURI = workingURI;
        }
        this._cleaner = Remark.updateCleaner(domain, this._options, this._HTMLFilters);
        doc = this._cleaner.clean(doc);
        if (this._cleanedHtmlEchoed) {
            System.out.println("Cleaned and processed HTML document:");
            System.out.println(doc.toString());
            System.out.println();
        }
        String result = null;
        this._converterLock.lock();
        try {
            if (writer != null) {
                this._converter.convert(doc, writer, aw, baseURI, domain);
            } else if (os != null) {
                this._converter.convert(doc, os, aw, baseURI, domain);
            } else {
                result = this._converter.convert(doc, aw, baseURI, domain);
            }
        }
        finally {
            this._converterLock.unlock();
            this.resetCleaner();
        }
        return result;
    }

    private final class StreamRemark
    extends Remark {
        private final Remark remark;
        private final Writer writer;
        private final OutputStream os;
        private final ProvenanceWriter aw;

        private StreamRemark(Remark remark2, Writer writer) {
            this.remark = remark2;
            this.writer = writer;
            this.os = null;
            this.aw = null;
        }

        private StreamRemark(Remark remark2, OutputStream out) {
            this.remark = remark2;
            this.writer = null;
            this.os = out;
            this.aw = null;
        }

        private StreamRemark(Remark remark2, ProvenanceWriter aw) throws Exception {
            this.remark = remark2;
            this.writer = null;
            this.os = null;
            this.aw = aw;
        }

        private StreamRemark(Remark remark2, Writer writer, JSONObject HTMLFilters) {
            this.remark = remark2;
            this.writer = writer;
            this.os = null;
            this.aw = null;
            try {
                this.remark.setHTMLFilters(StreamRemark.getHTMLFilters(HTMLFilters, DocumentConverter.DEFAULT_DOMAIN));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            remark2._cleaner = StreamRemark.updateCleaner(DocumentConverter.DEFAULT_DOMAIN, this.remark._options, HTMLFilters);
        }

        private StreamRemark(Remark remark2, OutputStream out, JSONObject HTMLFilters) {
            this.remark = remark2;
            this.writer = null;
            this.os = out;
            this.aw = null;
            try {
                this.remark.setHTMLFilters(StreamRemark.getHTMLFilters(HTMLFilters, DocumentConverter.DEFAULT_DOMAIN));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            remark2._cleaner = StreamRemark.updateCleaner(DocumentConverter.DEFAULT_DOMAIN, this.remark._options, HTMLFilters);
        }

        private StreamRemark(Remark remark2, ProvenanceWriter aw, JSONObject HTMLFilters) {
            this.remark = remark2;
            this.writer = null;
            this.os = null;
            this.aw = aw;
            try {
                this.remark.setHTMLFilters(StreamRemark.getHTMLFilters(HTMLFilters, DocumentConverter.DEFAULT_DOMAIN));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            remark2._cleaner = StreamRemark.updateCleaner(DocumentConverter.DEFAULT_DOMAIN, this.remark._options, HTMLFilters);
        }

        @Override
        public Remark withWriter(Writer writer) {
            return this.remark.withWriter(writer);
        }

        @Override
        public Remark withOutputStream(OutputStream os) {
            return this.remark.withOutputStream(os);
        }

        @Override
        public String convert(Document doc, String baseUri) {
            return this.remark.processConvert(doc, this.writer, this.os, this.aw, baseUri);
        }
    }
}

