/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.utility;

import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLUtils;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.List;

public class JSONFormat {
    public static void main(String[] args) {
        JSONFormat pgm = new JSONFormat();
        if (args.length == 2) {
            try {
                List<Path> files = MDfromHTMLUtils.listSourceFiles(FileSystems.getDefault().getPath(args[0], new String[0]), args[1]);
                for (Path file : files) {
                    pgm.doWork(file.toString());
                }
            }
            catch (Exception e) {
                System.out.println("Can not reference files with extension " + args[1] + " in directory " + args[0] + " reason: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        } else if (args.length == 1 && !args[0].toLowerCase().equals("-h")) {
            pgm.doWork(args[0]);
        } else {
            System.out.println("Usage:\n  Pass in a qualified JSON filename to format that file or\n  Pass in a qualified directory and the file extension\n    (without the period) of files to be formatted.\n  Examples:\n    java -cp \"MDfromHTMLBase-0.0.1.jar:API4JSON-1.0.1.jar:javax.ws.rs-api-2.1.1.jar\" com.mdfromhtml.utility.JSONFormat \"/somedir/somefile.json\"\n    java -cp \"MDfromHTMLBase-0.0.1.jar:API4JSON-1.0.1.jar:javax.ws.rs-api-2.1.1.jar\" com.mdfromhtml.utility.JSONFormat \"/somedir/someotherdir json\"\n");
        }
        System.out.println("Goodbye");
    }

    void doWork(String file) {
        try {
            JSONObject dialogsObj = MDfromHTMLUtils.loadJSONFile(file);
            MDfromHTMLUtils.saveJSONFile(file, dialogsObj);
            System.out.println("Formatted JSON in " + file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

