/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.remark.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class CleanupMarkdown {
    public static String cleanAll(String markdown, boolean seekHeaders) {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(markdown));
        String line = "";
        String test = "";
        boolean reachedHeader = !seekHeaders;
        try {
            while ((line = br.readLine()) != null) {
                if (!reachedHeader) {
                    test = line.trim();
                    if (!test.startsWith("#")) continue;
                    reachedHeader = true;
                }
                if (CleanupMarkdown.isEmptyHeader(line) || CleanupMarkdown.isEmptyListItem(line)) continue;
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!reachedHeader) {
            sb = new StringBuffer(markdown);
        }
        return sb.toString();
    }

    static String cleanImageTags(String line) {
        int indexTag = line.indexOf("<img ");
        int indexEndTag = line.indexOf("/>");
        if (indexTag >= 0 && indexEndTag > indexTag) {
            String tmp = line.substring(0, indexTag);
            line = tmp + line.substring(indexEndTag + 2);
        }
        return line;
    }

    static String cleanURLReference(String line, BufferedReader br) {
        String test = line.trim();
        int indexOpen = test.indexOf("[");
        int indexClose = test.indexOf("]");
        if (indexOpen == -1) {
            return line;
        }
        if (indexClose != -1) {
            return line;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(test);
        try {
            String nextLine = br.readLine();
            while (nextLine != null) {
                test = nextLine.trim();
                indexClose = test.indexOf("]");
                if (indexClose != -1) {
                    sb.append(test);
                    break;
                }
                sb.append(test);
                nextLine = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    static boolean isEmptyHeader(String line) {
        String[] parts;
        boolean result = false;
        String test = line.trim();
        if (test.startsWith("#") && test.endsWith("#") && (parts = test.split("(#)\\1+")).length == 2 && parts[1].trim().length() == 0) {
            result = true;
        }
        return result;
    }

    static boolean isEmptyListItem(String line) {
        boolean result = false;
        String test = line.trim();
        if ("*".equals(test)) {
            result = true;
        }
        return result;
    }

    public static void main(String[] args) {
        String emptyHeader = "####   ####";
        String test = CleanupMarkdown.removeEmptyHeaders(emptyHeader);
        System.out.println(emptyHeader + " became \"" + test + "\"");
        String goodHeader = "#### Some Header ####";
        test = CleanupMarkdown.removeEmptyHeaders(goodHeader);
        System.out.println(goodHeader + " became \"" + test + "\"");
    }

    public static String removeEmptyHeaders(String markdown) {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(markdown));
        String line = "";
        try {
            while ((line = br.readLine()) != null) {
                if (CleanupMarkdown.isEmptyHeader(line) || CleanupMarkdown.isEmptyListItem(line)) continue;
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String removeEmptyListItems(String markdown) {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(markdown));
        String line = "";
        try {
            while ((line = br.readLine()) != null) {
                if (CleanupMarkdown.isEmptyListItem(line)) continue;
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

