/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.remark.test;

import com.api.json.JSON;
import com.api.json.JSONArray;
import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLUtils;
import com.overzealous.remark.Remark;
import com.overzealous.remark.convert.ProvenanceWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class ProcessHTMLfromJSON {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        JSONArray htmlList = new JSONArray();
        try {
            File testFile = new File("src/test/resources/Archive0001.json");
            JSONObject filejson = (JSONObject)JSON.parse(new FileInputStream(testFile));
            htmlList = (JSONArray)filejson.get("captureArray");
        }
        catch (IOException e1) {
            System.out.println("Can not find file \"url_html_info.json\". Goodbye. " + e1.getLocalizedMessage());
            System.exit(-1);
        }
        String url = null;
        String html = null;
        String outputFileName = null;
        int htmlCounter = 0;
        ProvenanceWriter annotations = null;
        try {
            Remark remark = new Remark();
            for (Object obj : htmlList) {
                ++htmlCounter;
                outputFileName = "Archive0001.md";
                JSONObject htmlObj = (JSONObject)obj;
                url = (String)htmlObj.get("url");
                html = (String)htmlObj.get("html");
                System.out.println("\n" + url + "\n" + outputFileName);
                String htmlOutputFileName = "Archive0001_" + MDfromHTMLUtils.padLeftZero(htmlCounter, 3) + ".html";
                MDfromHTMLUtils.saveTextFile(htmlOutputFileName, html);
                Document doc = Jsoup.parse(html, url);
                String formattedHTML = doc.toString();
                String formattedHTMLOutputFileName = "Archive0001_" + MDfromHTMLUtils.padLeftZero(htmlCounter, 3) + "_formatted.html";
                MDfromHTMLUtils.saveTextFile(formattedHTMLOutputFileName, formattedHTML);
                String markdownOutputFileName = "Archive0001_" + MDfromHTMLUtils.padLeftZero(htmlCounter, 3) + ".md";
                String provenanceOutputFileName = "Archive0001_" + MDfromHTMLUtils.padLeftZero(htmlCounter, 3) + ".annotations";
                File provenanceOutputFile = new File(provenanceOutputFileName);
                if (provenanceOutputFile.exists()) {
                    provenanceOutputFile.delete();
                }
                annotations = new ProvenanceWriter(formattedHTMLOutputFileName, markdownOutputFileName, remark.getHTMLFilters(), null, null, new FileWriter(provenanceOutputFile, true));
                String markdown = remark.convert(doc, annotations);
                MDfromHTMLUtils.saveTextFile(markdownOutputFileName, markdown);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            if (annotations != null) {
                try {
                    annotations.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

