/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.markdown.transform;

import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLUtils;
import com.mdfromhtml.markdown.transform.TextUtils;
import com.overzealous.remark.Options;
import com.overzealous.remark.Remark;
import com.overzealous.remark.convert.ProvenanceWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class GetTextFromMarkdown {
    String _ext = "md";
    JSONObject _HTMLFilters = new JSONObject();
    Path _inputPath = null;
    boolean _interactive = false;
    Options _options = Options.multiMarkdown();
    String _outputPath = ".";
    boolean _thumbsucker = false;
    String _txtext = "txt";
    static boolean _includeLinks = false;

    public static void main(String[] args) {
        int exitVal = 0;
        JSONObject HTMLFilters = null;
        try {
            HTMLFilters = MDfromHTMLUtils.loadJSONFile("HTML_Filters.json");
        }
        catch (Exception e1) {
            System.out.println("Warning: Using no HTML Filters -- can not find \"HTML_Filters.json\": " + e1.getLocalizedMessage());
        }
        GetTextFromMarkdown pgm = new GetTextFromMarkdown(Options.multiMarkdown(), HTMLFilters);
        if (pgm.getParams(args)) {
            if (pgm._thumbsucker) {
                System.out.println("\nFiles ending with ." + pgm._ext + " will be read from " + pgm._inputPath + "\nand the generated text files (." + pgm._txtext + ") will be saved in " + pgm._outputPath + "\nIt is " + _includeLinks + " that links will be included in the text output.");
            }
            if (pgm._interactive && MDfromHTMLUtils.prompt("Press q to quit or press Enter to continue...").length() == 0) {
                pgm._interactive = false;
            }
            if (!pgm._interactive) {
                try {
                    Path file;
                    List<Path> files = MDfromHTMLUtils.listSourceFiles(FileSystems.getDefault().getPath(pgm._inputPath.toString(), new String[0]), pgm._ext);
                    Iterator<Path> iterator = files.iterator();
                    while (iterator.hasNext() && (exitVal = pgm.doWork(file = iterator.next())) == 0) {
                    }
                }
                catch (Exception e) {
                    System.out.println("Error: Can not reference files with extension " + pgm._ext + " in directory " + pgm._inputPath + " reason: " + e.getLocalizedMessage());
                    exitVal = -1;
                }
            }
            if (pgm._thumbsucker) {
                System.out.println();
            }
        } else {
            exitVal = -1;
        }
        if (pgm._thumbsucker) {
            System.out.println("Goodbye");
        }
    }

    public GetTextFromMarkdown() {
    }

    public GetTextFromMarkdown(Options options, JSONObject HTMLFilters) {
        this._options = options;
        this._HTMLFilters = HTMLFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doWork(Path file) {
        int exitVal;
        block18: {
            exitVal = 0;
            ProvenanceWriter provenanceWriter = null;
            String html2mdProvenanceFileName = "unknown";
            String provenanceOutputFileName = "unknown";
            JSONObject provenance = null;
            String textOutputFileName = "unknown";
            try {
                String fqFileName = file.toString();
                if (this._thumbsucker) {
                    System.out.println("Processing: " + fqFileName);
                }
                List<String> markdownList = MDfromHTMLUtils.loadTextFile(fqFileName);
                String shortFileName = fqFileName.substring(fqFileName.lastIndexOf(File.separator) + 1);
                int index = shortFileName.lastIndexOf("." + this._ext);
                if (index < 1) {
                    System.out.println("Error: " + shortFileName + "doesn't end with ." + this._ext);
                    exitVal = -1;
                    break block18;
                }
                html2mdProvenanceFileName = this._inputPath + File.separator + shortFileName.substring(0, index) + "_html2md.json";
                provenanceOutputFileName = this._outputPath + shortFileName.substring(0, index) + "_md2txt.json";
                provenance = MDfromHTMLUtils.loadJSONFile(html2mdProvenanceFileName);
                this._HTMLFilters = (JSONObject)provenance.get("htmlFilters");
                String baseURI = (String)provenance.get("baseURI");
                textOutputFileName = this._outputPath + shortFileName.substring(0, index) + "." + this._txtext;
                String domain = Remark.getDomain(baseURI);
                File provenanceOutputFile = new File(provenanceOutputFileName);
                if (provenanceOutputFile.exists()) {
                    provenanceOutputFile.delete();
                }
                provenanceWriter = new ProvenanceWriter(fqFileName, textOutputFileName, this._HTMLFilters, baseURI, domain, new FileWriter(provenanceOutputFile, true));
                try {
                    StringBuffer sb = new StringBuffer();
                    int lineNum = 0;
                    Map<String, String> refURLs = GetTextFromMarkdown.findRefURLs(markdownList);
                    for (String mdLine : markdownList) {
                        ++lineNum;
                        if (mdLine.equals("###### Doc2Dial Provenance ######")) break;
                        String testLine = GetTextFromMarkdown.generateTextFromMarkdown(mdLine, refURLs);
                        if (testLine == null) continue;
                        provenanceWriter.saveMD2Text("" + lineNum, mdLine, testLine);
                        sb.append(testLine);
                        sb.append("\n");
                    }
                    MDfromHTMLUtils.saveTextFile(textOutputFileName, sb.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    exitVal = -1;
                }
                finally {
                    if (provenanceWriter != null) {
                        try {
                            provenanceWriter.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                exitVal = -1;
            }
        }
        return exitVal;
    }

    public static Map<String, String> findRefURLs(List<String> mdLines) {
        HashMap<String, String> refURLs = new HashMap<String, String>();
        int offset = 0;
        String url = "";
        String ref = "";
        for (String mdLine : mdLines) {
            if (!(mdLine = mdLine.trim()).startsWith("[") || (offset = mdLine.indexOf("]: ")) <= 1) continue;
            ref = mdLine.substring(1, offset).trim();
            url = mdLine.substring(offset + 3).trim();
            refURLs.put(ref, url);
        }
        return refURLs;
    }

    public static String generateTextFromMarkdown(String mdLine, Map<String, String> refURLs) {
        String test = mdLine.trim();
        if (test.length() > 0) {
            test = TextUtils.filterComments(test);
            if ((test = GetTextFromMarkdown.processText(test, refURLs)) != null) {
                test = test.trim();
            }
        }
        return test;
    }

    boolean getParams(String[] args) {
        File testOutput;
        String inputPath = "./src/test/resources";
        String outputPath = "./src/test/resources";
        String tmp = "";
        try {
            if (args.length >= 1) {
                inputPath = args[0];
            } else {
                this._interactive = true;
                this._thumbsucker = true;
                tmp = MDfromHTMLUtils.prompt("Enter the fully qualified path to directory containing " + this._ext + " multimarkdown files, or q to exit (" + inputPath + "):");
                if (tmp == null || tmp.length() == 0) {
                    tmp = inputPath;
                }
                if (tmp.toLowerCase().equals("q")) {
                    return false;
                }
                inputPath = tmp;
            }
            if (!inputPath.endsWith(File.separator)) {
                inputPath = inputPath + File.separator;
            }
            this._inputPath = FileSystems.getDefault().getPath(inputPath, new String[0]);
        }
        catch (InvalidPathException ipe) {
            System.out.println("Error: " + args[0] + " is not a valid directory to form a path.");
            return false;
        }
        if (args.length >= 2) {
            outputPath = args[1];
        } else {
            this._interactive = true;
            this._thumbsucker = true;
            tmp = MDfromHTMLUtils.prompt("Enter the fully qualified path to the text file output directory, or q to exit (" + outputPath + "):");
            if (tmp == null || tmp.length() == 0) {
                tmp = outputPath;
            }
            if (tmp.toLowerCase().equals("q")) {
                return false;
            }
            outputPath = tmp;
        }
        if (!outputPath.endsWith(File.separator)) {
            outputPath = outputPath + File.separator;
        }
        if (!(testOutput = new File(outputPath)).exists()) {
            System.out.println("Error: The output directory \"" + outputPath + "\" must exist.");
            return false;
        }
        if (!testOutput.isDirectory()) {
            System.out.println("Error: The output directory \"" + outputPath + "\" must be a directory.");
            return false;
        }
        this._outputPath = outputPath;
        String includeLinks = "n";
        if (args == null || args.length < 3) {
            tmp = MDfromHTMLUtils.prompt("Include links in text output (y=yes, n=no), or q to exit (" + includeLinks + "):");
            if (tmp == null || tmp.length() == 0) {
                tmp = includeLinks;
            }
            if (tmp.toLowerCase().equals("q")) {
                return false;
            }
            includeLinks = tmp.toLowerCase().substring(0, 1);
        } else {
            includeLinks = args[2].trim().toLowerCase().substring(0, 1);
        }
        _includeLinks = "y".equals(includeLinks);
        if (args.length >= 4) {
            this._thumbsucker = new Boolean(args[3]);
        }
        return true;
    }

    public static String getRef(String line) {
        String retVal = "";
        int startOffset = line.indexOf("[");
        if (startOffset > -1) {
            int endOffset = line.substring(startOffset).indexOf("]");
            if (startOffset > -1 && endOffset > startOffset) {
                retVal = line.substring(startOffset + 1, endOffset + startOffset).trim();
            }
        }
        return retVal;
    }

    public static String processText(String line, Map<String, String> refURLs) {
        StringBuffer sb = new StringBuffer();
        String testChanged = "";
        int lineLen = line.length();
        int offset = 0;
        while (offset < lineLen && line != null) {
            char startChar = line.charAt(offset);
            switch (startChar) {
                case '\\': {
                    if (++offset < lineLen) {
                        sb.append(line.charAt(offset));
                        ++offset;
                    }
                    if (offset < lineLen) {
                        line = line.substring(offset);
                        lineLen = line.length();
                    } else {
                        lineLen = 0;
                    }
                    offset = 0;
                    break;
                }
                case '!': {
                    if (offset < lineLen - 1) {
                        if ("[".equals(line.substring(offset + 1, offset + 2))) {
                            if ((line = GetTextFromMarkdown.removeReferencesAndLinks(line.substring(offset), refURLs)) == null) break;
                            offset = 0;
                            lineLen = line.length();
                            break;
                        }
                        sb.append("!");
                        line = line.substring(offset + 1);
                        offset = 0;
                        lineLen = line.length();
                        break;
                    }
                    sb.append("!");
                    offset = line.length();
                    break;
                }
                case '[': {
                    line = GetTextFromMarkdown.removeReferencesAndLinks(line.substring(offset), refURLs);
                    if (line == null) {
                        return null;
                    }
                    offset = 0;
                    lineLen = line.length();
                    break;
                }
                case '|': {
                    line = GetTextFromMarkdown.removeTableLines(line.substring(offset));
                    offset = 0;
                    lineLen = line.length();
                    break;
                }
                case '-': {
                    testChanged = GetTextFromMarkdown.removeTaskList(line.substring(offset));
                    if (testChanged.equals(line.substring(offset))) {
                        sb.append("-");
                        line = testChanged.substring(1);
                    } else {
                        line = testChanged;
                    }
                    offset = 0;
                    lineLen = line.length();
                    break;
                }
                case '`': {
                    line = GetTextFromMarkdown.removeFencing(line.substring(offset));
                    offset = 0;
                    lineLen = line.length();
                    break;
                }
                case '#': {
                    line = GetTextFromMarkdown.removeHeading(line.substring(offset));
                    offset = 0;
                    lineLen = line.length();
                    break;
                }
                case '_': {
                    line = GetTextFromMarkdown.removeUnderscore(line.substring(offset));
                    offset = 0;
                    lineLen = line.length();
                    break;
                }
                case '~': {
                    line = GetTextFromMarkdown.removeFencing(line.substring(offset));
                    line = GetTextFromMarkdown.removeEmphasis(line);
                    offset = 0;
                    lineLen = line.length();
                    break;
                }
                case '*': {
                    line = GetTextFromMarkdown.removeEmphasis(line.substring(offset));
                    offset = 0;
                    lineLen = line.length();
                    break;
                }
                default: {
                    sb.append(startChar);
                    ++offset;
                }
            }
        }
        String temp = sb.toString();
        temp = temp.replaceAll("\\\\:", ":");
        temp = temp.replaceAll("\\\\-", "-");
        return temp;
    }

    public static String removeUnderscore(String line) {
        StringBuffer sb = new StringBuffer();
        int lLen = line.length();
        boolean isEscaped = false;
        for (int i = 0; i < lLen; ++i) {
            if ('\\' == line.charAt(i)) {
                isEscaped = true;
            } else if ('_' == line.charAt(i)) {
                if (isEscaped) {
                    isEscaped = false;
                } else {
                    ++i;
                    while (i < lLen && line.charAt(i) == '_') {
                        ++i;
                    }
                }
            }
            if (i >= lLen) continue;
            sb.append(line.charAt(i));
        }
        return sb.toString();
    }

    public static String removeEmphasis(String line) {
        line = line.replaceAll("\\*", "");
        line = line.replaceAll("~", "");
        return line;
    }

    public static String removeFencing(String line) {
        int i;
        StringBuffer sb = new StringBuffer();
        String[] parts = line.split("```\\w+");
        for (i = 0; i < parts.length; ++i) {
            if (parts[i].length() == 0) continue;
            sb.append(parts[i]);
        }
        line = sb.toString();
        sb = new StringBuffer();
        parts = line.split("~~~\\w+");
        for (i = 0; i < parts.length; ++i) {
            if (parts[i].length() == 0) continue;
            sb.append(parts[i]);
        }
        line = sb.toString();
        line = line.replaceAll("~~~", "");
        line = line.replaceAll("`", "");
        return line;
    }

    public static String removeHeading(String line) {
        StringBuffer sb = new StringBuffer();
        String[] parts = line.split("#+");
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].length() == 0) continue;
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    public static String removeReferencesAndLinks(String line, Map<String, String> refURLs) {
        StringBuffer sb = new StringBuffer();
        String test = line.trim();
        char[] testChars = new char[test.length()];
        test.getChars(0, test.length(), testChars, 0);
        int offset = 0;
        boolean foundBracket = false;
        int bracketCnt = 0;
        int startOffset = -1;
        String refLink = "";
        String url = "";
        String ref = "";
        Stack<Integer> startOffsets = new Stack<Integer>();
        boolean isImageRef = false;
        boolean needLabel = false;
        for (char testChar : testChars) {
            switch (testChar) {
                case '[': {
                    if (!isImageRef) {
                        boolean bl = needLabel = !needLabel;
                    }
                    if (!foundBracket) {
                        foundBracket = true;
                    }
                    startOffsets.push(offset);
                    ++bracketCnt;
                    break;
                }
                case ']': {
                    if (!foundBracket) break;
                    --bracketCnt;
                    startOffset = (Integer)startOffsets.pop();
                    if (offset - startOffset > 1) {
                        if (offset + 1 < test.length()) {
                            if (':' == testChars[offset + 1]) {
                                return null;
                            }
                            refLink = test.substring(startOffset + 1, offset).trim();
                            if (needLabel) {
                                if (refLink.startsWith("^")) {
                                    refLink = refLink.substring(1);
                                }
                                if (_includeLinks) {
                                    sb.append("{ ");
                                    sb.append(refLink);
                                    sb.append(" }");
                                } else {
                                    sb.append(refLink);
                                }
                                ref = GetTextFromMarkdown.getRef(test.substring(offset)).trim();
                                if (ref.equals("")) {
                                    ref = refLink;
                                }
                                if ((url = refURLs.get(ref)) != null && _includeLinks) {
                                    sb.append(":{ ");
                                    sb.append(url);
                                    sb.append(" } ");
                                }
                            }
                            if (isImageRef) {
                                needLabel = true;
                            }
                        } else {
                            refLink = test.substring(startOffset + 1, offset).trim();
                            if (needLabel) {
                                if (refLink.startsWith("^")) {
                                    refLink = refLink.substring(1);
                                }
                                if (_includeLinks) {
                                    sb.append("{");
                                    sb.append(refLink);
                                    sb.append("}");
                                } else {
                                    sb.append(refLink);
                                }
                                ref = GetTextFromMarkdown.getRef(test.substring(offset)).trim();
                                if (ref.equals("")) {
                                    ref = refLink;
                                }
                                if ((url = refURLs.get(ref)) != null && _includeLinks) {
                                    sb.append(":{");
                                    sb.append(url);
                                    sb.append("} ");
                                }
                            }
                            if (isImageRef) {
                                needLabel = true;
                            }
                        }
                    }
                    if (bracketCnt != 0) break;
                    startOffset = -1;
                    foundBracket = false;
                    isImageRef = false;
                    break;
                }
                case '!': {
                    if (offset < test.length() - 1) {
                        if ('[' == testChars[offset + 1]) {
                            isImageRef = true;
                            needLabel = true;
                            break;
                        }
                        sb.append(testChar);
                        break;
                    }
                    sb.append(testChar);
                    break;
                }
                default: {
                    if (!startOffsets.empty()) break;
                    sb.append(testChar);
                }
            }
            ++offset;
        }
        return sb.toString();
    }

    public static String removeTableLines(String line) {
        line = line.replaceAll("\\|", "");
        line = line.replaceAll(":-{3,}", "");
        line = line.replaceAll("-{3,}:", "");
        line = line.replaceAll(":-*:", "");
        line = line.replaceAll("-{3,}", "");
        return line;
    }

    public static String removeTaskList(String line) {
        line = line.replaceAll("- [ ]", "( )");
        line = line.replaceAll("- [x]", "(x)");
        line = line.replaceAll("- [ x ]", "(x)");
        return line;
    }
}

