/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.markdown.transform;

import com.api.json.JSON;
import com.api.json.JSONArray;
import com.api.json.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mdfromhtml.core.MDfromHTMLUtils;
import com.mdfromhtml.remark.utils.CleanupMarkdown;
import com.overzealous.remark.Options;
import com.overzealous.remark.Remark;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.ProvenanceWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;

public class GetMarkdownFromHTML {
    String _ext = "json";
    Path _inputPath = null;
    boolean _interactive = false;
    String _outputPath = ".";
    Remark _remark = new Remark(Options.multiMarkdown());
    boolean _thumbsucker = false;
    boolean _keepProvenanceLinks = true;

    public static JSONObject getMarkdownFromHTML(JSONObject htmlObject) {
        JsonNode jsonnode;
        JSONObject result = new JSONObject();
        ObjectMapper mapper = new ObjectMapper();
        try {
            jsonnode = mapper.readTree(htmlObject.toString());
        }
        catch (IOException e) {
            result.put("errorMsg", (Object)String.format("Error: Can not parse the object: %s" + e.getLocalizedMessage(), new Object[0]));
            return result;
        }
        jsonnode = GetMarkdownFromHTML.getMarkdownFromHTML((ObjectNode)jsonnode);
        try {
            result = (JSONObject)JSON.parse(jsonnode.toString());
        }
        catch (IOException e) {
            result.put("errorMsg", (Object)String.format("Error: Can not parse the response object: %s" + e.getLocalizedMessage(), new Object[0]));
            return result;
        }
        return result;
    }

    public static ObjectNode getMarkdownFromHTML(ObjectNode htmlObject) {
        Boolean test;
        JSONObject domainFilters;
        JSONObject HTMLFilters;
        ObjectNode HTMLFiltersObj;
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        boolean returnProvenance = true;
        JsonNode testProv = htmlObject.get("returnProvenance");
        if (testProv != null && testProv.isBoolean()) {
            returnProvenance = testProv.asBoolean();
        }
        if ((HTMLFiltersObj = (ObjectNode)htmlObject.get("HTMLFilters")) == null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode filters = mapper.readTree(new File("HTML_Filters.json"));
                HTMLFiltersObj = (ObjectNode)filters;
            }
            catch (Exception e1) {
                result.put("errorMsg", "Error: Can not find \"HTML_Filters\" in the request, nor can a file named \"HTML_Filters.json\" be found: " + e1.getLocalizedMessage());
                return result;
            }
        }
        try {
            String htmlFilters = HTMLFiltersObj.toString().toLowerCase();
            HTMLFilters = (JSONObject)JSON.parse(htmlFilters);
        }
        catch (IOException e) {
            result.put("errorMsg", "Error: Can not find parse the content of the \"HTML_Filters.json\" file: " + e.getLocalizedMessage());
            return result;
        }
        Options options = Options.multiMarkdown();
        options.hardwraps = true;
        GetMarkdownFromHTML pgm = new GetMarkdownFromHTML(options, HTMLFilters);
        JsonNode temp = htmlObject.get("html");
        if (temp == null) {
            ArrayNode captureArray = (ArrayNode)htmlObject.get("captureArray");
            if (captureArray != null && captureArray.size() > 0) {
                ObjectNode obj = (ObjectNode)captureArray.get(0);
                temp = obj.get("html");
                if (temp == null) {
                    result.put("errorMsg", "The request captureArray is missing the required \"html\" key so there is nothing to process.");
                    return result;
                }
            } else {
                result.put("errorMsg", "The request is missing the required \"html\" or \"captureArray\" key so there is nothing to process.");
                return result;
            }
        }
        String html = temp.asText();
        temp = htmlObject.get("url");
        if (temp == null) {
            result.put("errorMsg", "The request is missing the required \"url\" key.");
            return result;
        }
        String baseURI = temp.asText();
        Document doc = Jsoup.parse(html, baseURI);
        doc.outputSettings().escapeMode(Entities.EscapeMode.extended);
        boolean seekHeaders = true;
        String domain = Remark.getDomain(baseURI);
        int testindex = baseURI.indexOf(domain);
        String workingURI = baseURI.substring(testindex + domain.length());
        testindex = workingURI.toLowerCase().indexOf("http");
        if (testindex >= 0) {
            workingURI = workingURI.substring(testindex);
            domain = Remark.getDomain(workingURI);
            baseURI = workingURI;
        }
        if ((domainFilters = (JSONObject)HTMLFilters.get(domain)) != null && (test = (Boolean)domainFilters.get(DocumentConverter.SEEK_HEADERS)) != null) {
            seekHeaders = test;
        }
        ProvenanceWriter provWriter = null;
        StringWriter sw = null;
        BufferedWriter bw = null;
        if (returnProvenance) {
            sw = new StringWriter();
            bw = new BufferedWriter(sw);
            try {
                provWriter = new ProvenanceWriter("", "", HTMLFilters, baseURI, domain, bw);
            }
            catch (IOException e) {
                e.printStackTrace();
                provWriter = null;
            }
        }
        String markdown = pgm.generateMarkdownFromHTML(doc, provWriter, baseURI, seekHeaders);
        result.set("HTMLFilters", HTMLFiltersObj);
        if (returnProvenance && provWriter != null) {
            try {
                provWriter.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            String provenance = sw.getBuffer().toString();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode provObj = null;
            try {
                provObj = mapper.readTree(provenance);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            result.set("provenance", provObj);
            ObjectNode testHTMLFilters = (ObjectNode)provObj.get("HTMLFilters");
            if (testHTMLFilters != null) {
                result.set("HTMLFilters", testHTMLFilters);
            }
        }
        ArrayNode captureArray = JsonNodeFactory.instance.arrayNode();
        ObjectNode htmlInfo = JsonNodeFactory.instance.objectNode();
        htmlInfo.put("content", doc.text());
        htmlInfo.put("html", html);
        htmlInfo.put("url", baseURI);
        captureArray.add(htmlInfo);
        result.set("captureArray", captureArray);
        result.set("markdown", JsonNodeFactory.instance.textNode(markdown));
        result.put("returnProvenance", returnProvenance);
        result.put("url", baseURI);
        return result;
    }

    public static void main(String[] args) {
        int exitVal = 0;
        JSONObject HTMLFilters = null;
        try {
            HTMLFilters = MDfromHTMLUtils.loadJSONFile("HTML_Filters.json");
            try {
                HTMLFilters = (JSONObject)JSON.parse(HTMLFilters.toString().toLowerCase());
            }
            catch (Exception e) {
                System.out.println("Error: \"HTML_Filters.json\" has a parsing error: " + e.getLocalizedMessage());
                return;
            }
        }
        catch (Exception e1) {
            System.out.println("Error: No HTML Filters -- can not find \"HTML_Filters.json\": " + e1.getLocalizedMessage());
            return;
        }
        Options options = Options.multiMarkdown();
        options.hardwraps = true;
        GetMarkdownFromHTML pgm = new GetMarkdownFromHTML(options, HTMLFilters);
        if (pgm.getParams(args)) {
            if (pgm._thumbsucker) {
                System.out.println("\nFiles ending with ." + pgm._ext + " will be read from " + pgm._inputPath + "\nand the generated markdown (.md), and html (.html and _foramtted.html) saved in " + pgm._outputPath);
            }
            if (pgm._interactive && MDfromHTMLUtils.prompt("Press q to quit or press Enter to continue...").length() == 0) {
                pgm._interactive = false;
            }
            if (!pgm._interactive) {
                try {
                    Path file;
                    List<Path> files = MDfromHTMLUtils.listSourceFiles(FileSystems.getDefault().getPath(pgm._inputPath.toString(), new String[0]), pgm._ext);
                    Iterator<Path> iterator = files.iterator();
                    while (iterator.hasNext() && (exitVal = pgm.doWork(file = iterator.next(), HTMLFilters)) == 0) {
                    }
                }
                catch (Exception e) {
                    System.out.println("Error: Can not reference files with extension " + pgm._ext + " in directory " + pgm._inputPath + " reason: " + e.getLocalizedMessage());
                    exitVal = -1;
                }
            }
            if (pgm._thumbsucker) {
                System.out.println();
            }
        } else {
            exitVal = -1;
        }
        if (pgm._thumbsucker) {
            System.out.println("Goodbye");
        }
        System.exit(exitVal);
    }

    public GetMarkdownFromHTML(Options options, JSONObject HTMLFilters) {
        this._remark = new Remark(options, HTMLFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doWork(Path file, JSONObject HTMLFilters) {
        int exitVal;
        block24: {
            exitVal = 0;
            ProvenanceWriter provenanceWriter = null;
            String provenanceOutputFileName = "unknown";
            try {
                String fqFileName = file.toString();
                if (this._thumbsucker) {
                    System.out.println("Processing: " + fqFileName);
                }
                ObjectMapper mapper = new ObjectMapper();
                File jsonTestFile = new File(file.toString());
                JsonNode tempJSON = mapper.readTree(jsonTestFile);
                String shortFileName = fqFileName.substring(fqFileName.lastIndexOf(File.separator) + 1);
                int index = shortFileName.lastIndexOf("." + this._ext);
                if (index < 1) {
                    System.out.println(shortFileName + "doesn't end with ." + this._ext);
                    exitVal = -1;
                    break block24;
                }
                ObjectNode inputJson = (ObjectNode)tempJSON;
                int htmlCounter = 0;
                ArrayNode htmlList = (ArrayNode)inputJson.get("captureArray");
                if (htmlList == null) {
                    JsonNode htmlObj = inputJson.get("captureDict");
                    if (htmlObj == null) {
                        System.err.println(fqFileName + " is missing the \"captureArray\" and the \"captureDict\" tag. Please fix and retry.");
                        System.exit(-1);
                    }
                    htmlList = JsonNodeFactory.instance.arrayNode();
                    htmlList.add(htmlObj);
                }
                String baseURI = null;
                String html = null;
                JsonNode temp = null;
                for (JsonNode obj : htmlList) {
                    boolean seekHeaders = true;
                    try {
                        Boolean test;
                        ++htmlCounter;
                        ObjectNode htmlObj = (ObjectNode)obj;
                        temp = htmlObj.get("html");
                        if (temp == null) {
                            System.err.println(fqFileName + " is missing the \"html\" key in the [" + (htmlCounter - 1) + "] element of the captureArray.");
                            System.exit(-1);
                        }
                        html = temp.asText();
                        temp = htmlObj.get("url");
                        if (temp == null) {
                            System.err.println(fqFileName + " is missing the \"utl\" key in the [" + (htmlCounter - 1) + "] element of the captureArray.");
                            System.exit(-1);
                        }
                        baseURI = temp.asText();
                        String htmlOutputFileName = this._outputPath + shortFileName.substring(0, index) + "_" + MDfromHTMLUtils.padLeftZero(htmlCounter, 3) + ".html";
                        MDfromHTMLUtils.saveTextFile(htmlOutputFileName, html);
                        Document doc = Jsoup.parse(html, baseURI);
                        doc.outputSettings().escapeMode(Entities.EscapeMode.extended);
                        String formattedHTML = doc.toString();
                        formattedHTML = formattedHTML.replaceAll("&amp;", "&");
                        formattedHTML = formattedHTML.replaceAll("&quot;", "\"");
                        String formattedHTMLOutputFileName = this._outputPath + shortFileName.substring(0, index) + "_" + MDfromHTMLUtils.padLeftZero(htmlCounter, 3) + "_formatted.html";
                        MDfromHTMLUtils.saveTextFile(formattedHTMLOutputFileName, formattedHTML);
                        String domain = Remark.getDomain(baseURI);
                        int testindex = baseURI.indexOf(domain);
                        String workingURI = baseURI.substring(testindex + domain.length());
                        testindex = workingURI.toLowerCase().indexOf("http");
                        if (testindex >= 0) {
                            workingURI = workingURI.substring(testindex);
                            domain = Remark.getDomain(workingURI);
                            baseURI = workingURI;
                        }
                        String markdownOutputFileName = this._outputPath + shortFileName.substring(0, index) + "_" + MDfromHTMLUtils.padLeftZero(htmlCounter, 3) + ".md";
                        provenanceOutputFileName = this._outputPath + shortFileName.substring(0, index) + "_" + MDfromHTMLUtils.padLeftZero(htmlCounter, 3) + "_html2md.json";
                        File provenanceOutputFile = new File(provenanceOutputFileName);
                        if (provenanceOutputFile.exists()) {
                            provenanceOutputFile.delete();
                        }
                        provenanceWriter = new ProvenanceWriter(formattedHTMLOutputFileName, markdownOutputFileName, this._remark.getHTMLFilters(), baseURI, domain, new FileWriter(provenanceOutputFile, true));
                        JSONObject domainFilters = (JSONObject)HTMLFilters.get(domain);
                        if (domainFilters != null && (test = (Boolean)domainFilters.get(DocumentConverter.SEEK_HEADERS)) != null) {
                            seekHeaders = test;
                        }
                        String markdown = this.generateMarkdownFromHTML(doc, provenanceWriter, baseURI, seekHeaders);
                        if (this._keepProvenanceLinks) {
                            markdown = markdown + "\n###### Doc2Dial Provenance ######\n\n * [Doc2Dial Original URL][]\n * [Doc2Dial File Processed][]\n\n[Doc2Dial Original URL]: " + baseURI.replaceAll(" ", "%20") + "\n[Doc2Dial File Processed]: file://" + file.toAbsolutePath().toString();
                        }
                        MDfromHTMLUtils.saveTextFile(markdownOutputFileName, markdown);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exitVal = -1;
                    }
                    finally {
                        if (provenanceWriter == null) continue;
                        try {
                            provenanceWriter.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        provenanceWriter = null;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                exitVal = -1;
            }
        }
        return exitVal;
    }

    String generateMarkdownFromHTML(Document doc, ProvenanceWriter provenanceWriter, String baseUri, boolean seekHeaders) {
        String markdown = this._remark.convert(doc, provenanceWriter, baseUri);
        markdown = CleanupMarkdown.cleanAll(markdown, seekHeaders);
        return GetMarkdownFromHTML.removeUnusedReferences(markdown);
    }

    void cleanUpAnnotations(String provenanceFileName) throws Exception {
        JSONObject annotation;
        String md;
        JSONObject provenanceObj = MDfromHTMLUtils.loadJSONFile(provenanceFileName);
        JSONArray provenanceArray = (JSONArray)provenanceObj.get("provenance");
        Iterator it = provenanceArray.iterator();
        while (it.hasNext() && (md = (String)(annotation = (JSONObject)it.next()).get("md")) != null && !md.startsWith("#")) {
            it.remove();
        }
        provenanceObj.put("provenance", (Object)provenanceArray);
        MDfromHTMLUtils.saveJSONFile(provenanceFileName, provenanceObj);
    }

    boolean getParams(String[] args) {
        File testOutput;
        String inputPath = "./src/test/resources";
        String outputPath = "./src/test/resources";
        String tmp = "";
        try {
            if (args.length >= 1) {
                inputPath = args[0];
            } else {
                this._interactive = true;
                this._thumbsucker = true;
                tmp = MDfromHTMLUtils.prompt("Enter the fully qualified path to directory containing " + this._ext + " html capture files, or q to exit (" + inputPath + "):");
                if (tmp == null || tmp.length() == 0) {
                    tmp = inputPath;
                }
                if (tmp.toLowerCase().equals("q")) {
                    return false;
                }
                inputPath = tmp;
            }
            if (!inputPath.endsWith(File.separator)) {
                inputPath = inputPath + File.separator;
            }
            this._inputPath = FileSystems.getDefault().getPath(inputPath, new String[0]);
        }
        catch (InvalidPathException ipe) {
            System.out.println("Error: " + args[0] + " is not a valid directory to form a path.");
            return false;
        }
        if (args.length >= 2) {
            outputPath = args[1];
        } else {
            this._interactive = true;
            this._thumbsucker = true;
            tmp = MDfromHTMLUtils.prompt("Enter the fully qualified path to the markdown output directory, or q to exit (" + outputPath + "):");
            if (tmp == null || tmp.length() == 0) {
                tmp = outputPath;
            }
            if (tmp.toLowerCase().equals("q")) {
                return false;
            }
            outputPath = tmp;
        }
        if (!outputPath.endsWith(File.separator)) {
            outputPath = outputPath + File.separator;
        }
        if (!(testOutput = new File(outputPath)).exists()) {
            System.out.println("Error: The output directory \"" + outputPath + "\" must exist.");
            return false;
        }
        if (!testOutput.isDirectory()) {
            System.out.println("Error: The output directory \"" + outputPath + "\" must be a directory.");
            return false;
        }
        this._outputPath = outputPath;
        if (args.length >= 3) {
            this._thumbsucker = new Boolean(args[2]);
        }
        if (args.length >= 4) {
            this._keepProvenanceLinks = new Boolean(args[3]);
        }
        return true;
    }

    Set<String> getReferences(String line) {
        HashSet<String> results = new HashSet<String>();
        String test = line.trim();
        int index = test.indexOf("[");
        int index2 = -1;
        String reference = "";
        while (index != -1 && (index2 = test.indexOf("]: ")) != -1) {
            if (index2 - index > 2) {
                reference = test.substring(index, index2 + 1);
                results.add(reference);
            }
            test = test.substring(index2 + 3);
            index = test.indexOf("[");
        }
        return results;
    }

    public static void getReferencesAndLinks(String line, Set<String> refLinks, Set<String> references) {
        String test = line.trim();
        char[] testChars = new char[test.length()];
        test.getChars(0, test.length(), testChars, 0);
        int offset = 0;
        boolean foundBracket = false;
        int bracketCnt = 0;
        int startOffset = -1;
        String refLink = "";
        String reference = "";
        Stack<Integer> startOffsets = new Stack<Integer>();
        for (char testChar : testChars) {
            switch (testChar) {
                case '[': {
                    if (!foundBracket) {
                        foundBracket = true;
                    }
                    startOffsets.push(offset);
                    ++bracketCnt;
                    break;
                }
                case ']': {
                    if (!foundBracket) break;
                    --bracketCnt;
                    startOffset = (Integer)startOffsets.pop();
                    if (offset - startOffset > 1) {
                        if (offset + 1 < test.length()) {
                            if (':' == testChars[offset + 1]) {
                                reference = test.substring(startOffset, offset + 1);
                                references.add(reference);
                            } else {
                                refLink = test.substring(startOffset, offset + 1);
                                refLinks.add(refLink);
                            }
                        } else {
                            refLink = test.substring(startOffset, offset + 1);
                            refLinks.add(refLink);
                        }
                    }
                    if (bracketCnt != 0) break;
                    startOffset = -1;
                    foundBracket = false;
                    break;
                }
            }
            ++offset;
        }
    }

    public static String removeUnusedReferences(String markdown) {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(markdown));
        String line = "";
        String test = "";
        HashSet<String> refLinks = new HashSet<String>();
        HashSet<String> references = new HashSet<String>();
        int index = -1;
        String refStr = "";
        try {
            while ((line = br.readLine()) != null) {
                GetMarkdownFromHTML.getReferencesAndLinks(line, refLinks, references);
            }
            for (String link : refLinks) {
                references.remove(link);
            }
            if (references.size() == 0) {
                sb = new StringBuffer(markdown);
            } else {
                br = new BufferedReader(new StringReader(markdown));
                while ((line = br.readLine()) != null) {
                    test = line.trim();
                    if (test.startsWith("[")) {
                        index = test.indexOf("]: ");
                        if (index != -1) {
                            refStr = test.substring(0, index + 1);
                            if (references.contains(refStr)) {
                                references.remove(refStr);
                                continue;
                            }
                        } else if (test.endsWith("]:")) continue;
                    }
                    sb.append(line);
                    sb.append("\n");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }
}

