/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.markdown.transform;

import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLUtils;
import com.overzealous.remark.Remark;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class FindUnfilteredDomains {
    public static void main(String[] args) {
        try {
            System.out.println("This utility will read URLs from a tab delimited file with urls in \nthe 2nd column and compare their domains against the domain filters in HTML_Filters.json.");
            System.out.println("Loading HTML_Filters.json");
            JSONObject htmlfilters = MDfromHTMLUtils.loadJSONFile("HTML_Filters.json");
            String fileToURLFilename = MDfromHTMLUtils.prompt("Enter the fully qualified path to the tab delimited file url cross reference file or q to quit:");
            if (fileToURLFilename.length() == 0) {
                fileToURLFilename = "./src/test/resources/file_to_url.txt";
            }
            if (!"q".equalsIgnoreCase(fileToURLFilename)) {
                List<String> urlfiles = MDfromHTMLUtils.loadTextFile(fileToURLFilename);
                String[] parts = new String[]{};
                String url = "";
                String domain = "";
                HashSet<String> unfiltered = new HashSet<String>();
                int urlCount = 1;
                System.out.println("Processing URLs (. == 50 urls processed)\n");
                for (String urlfile : urlfiles) {
                    parts = urlfile.split("\t");
                    url = parts[1];
                    domain = Remark.getDomain(url);
                    if (htmlfilters.get(domain) == null) {
                        unfiltered.add(domain);
                    }
                    if (urlCount % 50 == 0) {
                        System.out.print(".");
                    }
                    if (urlCount % 4000 == 0) {
                        System.out.println();
                    }
                    ++urlCount;
                }
                System.out.println("\n");
                ArrayList<String> unfilteredDomains = new ArrayList<String>();
                unfilteredDomains.addAll(unfiltered);
                Collections.sort(unfilteredDomains);
                System.out.println("Domains without filters:");
                for (String unfilteredDomain : unfilteredDomains) {
                    System.out.println(unfilteredDomain);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Goodbye");
    }
}

