/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.markdown.test;

import com.api.json.JSONArray;
import com.api.json.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mdfromhtml.core.MDfromHTMLUtils;
import com.mdfromhtml.markdown.transform.GetMarkdownFromHTML;
import java.io.File;

public class TestServiceAPIs {
    public ObjectNode loadHTMLFilters() throws Exception {
        ObjectNode HTMLFiltersObj = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode filters = mapper.readTree(new File("HTML_Filters.json"));
            HTMLFiltersObj = (ObjectNode)filters;
        }
        catch (Exception e1) {
            throw new Exception(String.format("Error: Can not find a file named \"HTML_Filters.json\": %s" + e1.getLocalizedMessage(), new Object[0]));
        }
        return HTMLFiltersObj;
    }

    public void runTests() throws Exception {
        JSONObject htmlObj;
        String htmlJsonFileName;
        Boolean requestProvenance = true;
        ObjectNode HTMLFilters = this.loadHTMLFilters();
        String html = "";
        String url = "";
        String testFileName = "./src/test/resources/Archive0001.json";
        while (true) {
            File inputFile;
            if ("q".equalsIgnoreCase(htmlJsonFileName = MDfromHTMLUtils.prompt("Enter the fully qualified htmljson file name or q to quit (" + testFileName + "):"))) {
                return;
            }
            if (htmlJsonFileName.length() == 0) {
                htmlJsonFileName = testFileName;
            }
            if ((inputFile = new File(htmlJsonFileName)).exists()) break;
            System.out.println("Can not find \"" + htmlJsonFileName + "\". Try again.");
        }
        String provTest = MDfromHTMLUtils.prompt("Return provenance? (y/n/q to quit):");
        if ("q".equalsIgnoreCase(provTest)) {
            return;
        }
        requestProvenance = "y".equalsIgnoreCase(provTest);
        JSONObject htmljsonObj = MDfromHTMLUtils.loadJSONFile(htmlJsonFileName);
        JSONArray captureArray = (JSONArray)htmljsonObj.get("captureArray");
        if (captureArray == null) {
            System.out.println("The file specified is missing the required \"captureArray\" key. Try again.");
        }
        if ((htmlObj = (JSONObject)captureArray.get(0)) == null) {
            System.out.println("The file specified has an empty \"captureArray\". Try again.");
        }
        if ((html = (String)htmlObj.get("html")) == null) {
            System.out.println("The first object in the \"captureArray\" does not contain the required \"html\" key. Try again.");
        }
        if ((url = (String)htmlObj.get("url")) == null) {
            System.out.println("The first object in the \"captureArray\" does not contain the required \"url\" key. Try again.");
        }
        ObjectNode requestObj = JsonNodeFactory.instance.objectNode();
        requestObj.set("html", JsonNodeFactory.instance.textNode(html));
        requestObj.set("url", JsonNodeFactory.instance.textNode(url));
        requestObj.set("HTMLFilters", HTMLFilters);
        requestObj.put("returnProvenance", true);
        ObjectNode responseObj = GetMarkdownFromHTML.getMarkdownFromHTML(requestObj);
        JsonNode test = responseObj.get("errorMsg");
        if (test != null) {
            System.out.println("An error occurred: " + test.asText());
        }
        if ((test = responseObj.get("markdown")) == null) {
            System.out.println("Response is missing the \"markdown\" key.");
        }
        String markdown = test.asText();
        System.out.println("\nGenerated Markdown:\n" + markdown + "\n");
        if (requestProvenance.booleanValue()) {
            test = responseObj.get("provenance");
            if (test == null) {
                System.out.println("Response is missing the \"provenance\" key.");
            }
            try {
                ObjectMapper mapper = new ObjectMapper();
                Object json = mapper.readValue(responseObj.toString(), Object.class);
                System.out.println("\nResponse:\n" + mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        try {
            TestServiceAPIs pgm = new TestServiceAPIs();
            pgm.runTests();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        System.exit(0);
    }
}

