/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.core;

import com.api.json.JSON;
import com.api.json.JSONObject;
import com.mdfromhtml.core.IMDfromHTMLIPCMessage;
import com.mdfromhtml.core.MDfromHTMLDate;
import com.mdfromhtml.core.MDfromHTMLID;
import com.mdfromhtml.core.MDfromHTMLIPCApplications;
import com.mdfromhtml.core.MDfromHTMLIPCVerbs;
import com.mdfromhtml.core.MDfromHTMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public class MDfromHTMLIPCMessage
implements IMDfromHTMLIPCMessage,
Serializable {
    public static int IPC_MAX_MESSAGE_SIZE = MDfromHTMLIPCMessage.getIPCMaxMessageSize();
    private static final long serialVersionUID = -1298716658259442515L;
    private MDfromHTMLIPCApplications _appl = MDfromHTMLIPCApplications.MDfromHTML;
    private long _createTime = new MDfromHTMLDate().getTime();
    private boolean _isJSON = true;
    private byte[] _message = new byte[0];
    private String _publisherName = "?";
    private int _seqnum = 0;
    private MDfromHTMLID _sessionID = MDfromHTMLID.UNDEFINED_ID;
    private MDfromHTMLID _userID = MDfromHTMLID.UNDEFINED_ID;
    private String _topic = "?";
    private String _type = "?";
    private MDfromHTMLIPCVerbs _verb = MDfromHTMLIPCVerbs.UNDEFINED;

    public static int getIPCMaxMessageSize() {
        int maxSize = 327680;
        try {
            Properties props = MDfromHTMLUtils.getMDfromHTMLIPCProps();
            maxSize = new Integer(props.getProperty("IPC_MAX_MESSAGE_SIZE", "327680"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxSize;
    }

    public static MDfromHTMLIPCMessage fromByteArray(byte[] bytes) throws Exception {
        if (bytes == null || bytes.length < 8) {
            throw new Exception("Byte array is null or too short to be valid.");
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int headerLen = bb.getInt();
        if (headerLen < 0) {
            throw new Exception("Invalid header length in byte array.");
        }
        byte[] headerBytes = new byte[headerLen];
        bb.get(headerBytes);
        int bodyLen = bb.getInt();
        if (bodyLen < 0) {
            throw new Exception("Invalid body length in byte array.");
        }
        byte[] body = new byte[bodyLen];
        bb.get(body);
        String header = MDfromHTMLUtils.fromUTF8Bytes(headerBytes);
        String[] parts = header.split("~", -1);
        if (parts.length != 12) {
            throw new Exception("Malformed header in byte array.");
        }
        String publisherName = parts[1];
        MDfromHTMLID sessionID = MDfromHTMLID.getExistingID(parts[2]);
        MDfromHTMLIPCApplications appl = MDfromHTMLIPCApplications.fromValue(new Integer(parts[3]));
        String topic = parts[4];
        String type = parts[5];
        MDfromHTMLIPCVerbs verb = MDfromHTMLIPCVerbs.fromValue(new Integer(parts[6]));
        MDfromHTMLID userID = MDfromHTMLID.getExistingID(parts[7]);
        long time = new Long(parts[8]);
        int seq = new Integer(parts[9]);
        boolean isJSON = parts[10].compareToIgnoreCase("1") == 0;
        MDfromHTMLIPCMessage msg = null;
        if (isJSON && seq == 0) {
            JSONObject jsonObj;
            String strObj = MDfromHTMLUtils.fromUTF8Bytes(body);
            try {
                if ("JSON Generation Error: []".compareToIgnoreCase(strObj) == 0) {
                    strObj = "{}";
                }
                jsonObj = (JSONObject)JSON.parse(strObj);
            }
            catch (IOException | NullPointerException e) {
                throw new Exception("Error transforming data to JSONObject: \"" + strObj + "\"", e);
            }
            msg = new MDfromHTMLIPCMessage(publisherName, sessionID, appl, topic, type, verb, userID, jsonObj);
        } else {
            msg = new MDfromHTMLIPCMessage(publisherName, sessionID, appl, topic, type, verb, userID, body);
        }
        msg.setTime(time);
        msg.setSequence(seq);
        return msg;
    }

    public static MDfromHTMLIPCMessage getAssembledMessage(MDfromHTMLIPCMessage[] msgs) throws Exception {
        if (msgs == null || msgs.length == 0) {
            throw new Exception("Can not assemble null or empty array of messages.");
        }
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        String publisherName = null;
        MDfromHTMLID sessionID = MDfromHTMLID.UNDEFINED_ID;
        String topic = null;
        String type = null;
        MDfromHTMLIPCApplications appl = MDfromHTMLIPCApplications.UNDEFINED;
        MDfromHTMLIPCVerbs verb = MDfromHTMLIPCVerbs.UNDEFINED;
        MDfromHTMLID userID = MDfromHTMLID.UNDEFINED_ID;
        long msgTime = 0L;
        for (int i = 0; i < msgs.length; ++i) {
            if (i == 0) {
                publisherName = msgs[i].getPublisherName();
                sessionID = msgs[i].getSessionID();
                topic = msgs[i].getTopic();
                type = msgs[i].getType();
                msgTime = msgs[i].getTime();
                appl = msgs[i].getApplication();
                verb = msgs[i].getVerb();
                userID = msgs[i].getUserID();
            }
            try {
                ba.write(msgs[i].getMessageBytes());
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        MDfromHTMLIPCMessage msg = new MDfromHTMLIPCMessage(publisherName, sessionID, appl, topic, type, verb, userID, ba.toByteArray());
        msg.setTime(msgTime);
        return msg;
    }

    public static void main(String[] args) {
        int split = 9;
        try {
            MDfromHTMLIPCMessage[] msgs;
            if (args.length > 0) {
                split = new Integer(args[0]);
            }
            MDfromHTMLID sessionID = new MDfromHTMLID();
            MDfromHTMLID userID = new MDfromHTMLID();
            JSONObject testObj = new JSONObject();
            testObj.put("test", (Object)"0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789");
            MDfromHTMLIPCMessage msg = new MDfromHTMLIPCMessage(null, sessionID, MDfromHTMLIPCApplications.MDfromHTML, "topic1", "type1", MDfromHTMLIPCVerbs.UNDEFINED, userID, testObj);
            System.out.println("Split value is " + split);
            System.out.println("Start message:" + msg);
            for (MDfromHTMLIPCMessage xmsg : msgs = msg.getSequencedMessages(split)) {
                String seqStr = Integer.toString(xmsg.getSequence());
                if (xmsg.isLastMessage()) {
                    seqStr = "Last";
                }
                System.out.println(seqStr + ":\t" + MDfromHTMLUtils.fromUTF8Bytes(xmsg.getMessageBytes()));
            }
            MDfromHTMLIPCMessage newMsg = MDfromHTMLIPCMessage.getAssembledMessage(msgs);
            System.out.println("Reassembled message is \"" + newMsg.getMessage() + "\"");
            byte[] msgBytes = MDfromHTMLIPCMessage.toByteArray(newMsg);
            System.out.println("As bytes: " + MDfromHTMLUtils.hexEncode(msgBytes));
            try {
                newMsg = MDfromHTMLIPCMessage.fromByteArray(msgBytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Final message:" + newMsg);
            System.out.println("Message as JSON:" + newMsg.toJson());
            try {
                System.out.println("Message from JSON:" + new MDfromHTMLIPCMessage(newMsg.toJson()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] toByteArray(MDfromHTMLIPCMessage msg) throws Exception {
        if (msg == null) {
            throw new Exception("Message is null.");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("~");
        sb.append(msg.getPublisherName());
        sb.append("~");
        sb.append(msg.getSessionID());
        sb.append("~");
        sb.append(msg.getApplicationValue());
        sb.append("~");
        sb.append(msg.getTopic());
        sb.append("~");
        sb.append(msg.getType());
        sb.append("~");
        sb.append(msg.getVerbValue());
        sb.append("~");
        sb.append(msg.getUserID());
        sb.append("~");
        sb.append(msg.getTime());
        sb.append("~");
        sb.append(msg.getSequence());
        sb.append("~");
        sb.append(msg.isJSON() ? "1" : "0");
        sb.append("~");
        ByteBuffer bb = null;
        byte[] header = MDfromHTMLUtils.toUTF8Bytes(sb.toString());
        byte[] body = msg.getMessageBytes();
        bb = ByteBuffer.allocate(4 + header.length + 4 + body.length);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(header.length);
        bb.put(header);
        bb.putInt(body.length);
        bb.put(body);
        return bb.array();
    }

    public MDfromHTMLIPCMessage(String publisherName, MDfromHTMLID sessionID, MDfromHTMLIPCApplications appl, String topic, String type, MDfromHTMLIPCVerbs verb, MDfromHTMLID userID, byte[] message) {
        this.setPublisherName(publisherName);
        this.setSessionID(sessionID);
        this.setApplication(appl);
        this.setTopic(topic);
        this.setType(type);
        this.setVerb(verb);
        this.setUserID(userID);
        this.setMessageBytes(message);
    }

    public MDfromHTMLIPCMessage(String publisherName, MDfromHTMLID sessionID, MDfromHTMLIPCApplications appl, String topic, String type, MDfromHTMLIPCVerbs verb, MDfromHTMLID userID, JSONObject message) {
        this.setPublisherName(publisherName);
        this.setSessionID(sessionID);
        this.setApplication(appl);
        this.setTopic(topic);
        this.setType(type);
        this.setVerb(verb);
        this.setUserID(userID);
        this.setMessage(message);
    }

    public MDfromHTMLIPCMessage(JSONObject message) throws Exception {
        try {
            String publisherName = (String)message.get("publisher");
            this.setPublisherName(publisherName);
            MDfromHTMLID sessionID = MDfromHTMLID.getExistingID((String)message.get("sessionID"));
            this.setSessionID(sessionID);
            MDfromHTMLIPCApplications appl = MDfromHTMLIPCApplications.fromName((String)message.get("appl"));
            this.setApplication(appl);
            String topic = (String)message.get("topic");
            this.setTopic(topic);
            String type = (String)message.get("type");
            this.setType(type);
            MDfromHTMLIPCVerbs verb = MDfromHTMLIPCVerbs.fromName((String)message.get("verb"));
            this.setVerb(verb);
            MDfromHTMLID userID = MDfromHTMLID.getExistingID((String)message.get("userID"));
            this.setUserID(userID);
            Long seq = (Long)message.get("seq");
            this.setSequence(seq.intValue());
            Boolean isJSON = (Boolean)message.get("isJSON");
            if (isJSON.booleanValue()) {
                JSONObject msgObj = (JSONObject)message.get("msg");
                this.setMessage(msgObj);
            } else {
                String msgBytesStr = (String)message.get("msg");
                msgBytesStr = msgBytesStr.substring(2);
                byte[] msgBytes = MDfromHTMLUtils.hexDecode(msgBytesStr);
                this.setMessageBytes(msgBytes);
            }
        }
        catch (Exception e) {
            throw new Exception("Malformed message " + e.getLocalizedMessage(), e);
        }
    }

    private boolean checkIsJSON(byte[] bytes) {
        boolean isJSON = false;
        if (this._message.length > 1 && this._message[0] == 123 && this._message[this._message.length - 1] == 125) {
            try {
                JSON.parse(MDfromHTMLUtils.fromUTF8Bytes(this._message));
                isJSON = true;
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
        }
        return isJSON;
    }

    public static Properties getMDfromHTMLIPCProps() throws Exception {
        Properties ipcProps = MDfromHTMLUtils.loadMDfromHTMLProperties("MDfromHTMLIPC.properties");
        return ipcProps;
    }

    @Override
    public MDfromHTMLIPCApplications getApplication() {
        return this._appl;
    }

    @Override
    public int getApplicationValue() {
        return this._appl.getValue();
    }

    @Override
    public JSONObject getMessage() throws Exception {
        try {
            return (JSONObject)JSON.parse(this.getMessageString());
        }
        catch (IOException | NullPointerException e) {
            throw new Exception("Message contains invalid JSON", e);
        }
    }

    @Override
    public byte[] getMessageBytes() {
        return this._message;
    }

    protected int getMessageSize() {
        int iSize = 0;
        iSize += 4;
        iSize += "~".length();
        iSize += this._publisherName.length();
        iSize += "~".length();
        iSize += MDfromHTMLID.ID_LENGTH;
        iSize += "~".length();
        iSize += Integer.toString(this.getApplicationValue()).length();
        iSize += "~".length();
        iSize += this._topic.length();
        iSize += "~".length();
        iSize += this._type.length();
        iSize += "~".length();
        iSize += Integer.toString(this.getVerbValue()).length();
        iSize += "~".length();
        iSize += MDfromHTMLID.ID_LENGTH;
        iSize += "~".length();
        iSize += new Long(this._createTime).toString().length();
        iSize += "~".length();
        iSize += new Integer(this._seqnum).toString().length();
        iSize += "~".length();
        ++iSize;
        iSize += "~".length();
        iSize += 4;
        return iSize += this._message.length;
    }

    private String getMessageString() throws Exception {
        if (!this.isJSON()) {
            throw new Exception("Message contains non-String data. Use getMessageBytes() instead. \n0x" + MDfromHTMLUtils.hexEncode(this._message));
        }
        return MDfromHTMLUtils.fromUTF8Bytes(this._message);
    }

    @Override
    public String getPublisherName() {
        return this._publisherName;
    }

    @Override
    public int getSequence() {
        return this._seqnum;
    }

    public MDfromHTMLIPCMessage[] getSequencedMessages(int chunkSize) throws Exception {
        if (chunkSize < 2 || chunkSize > IPC_MAX_MESSAGE_SIZE) {
            throw new Exception("Invalid chunk size. Must be > 1 or < " + IPC_MAX_MESSAGE_SIZE + ".");
        }
        ArrayList<MDfromHTMLIPCMessage> list = new ArrayList<MDfromHTMLIPCMessage>();
        if (chunkSize >= this._message.length) {
            list.add(this);
        } else {
            int chunks = this._message.length / chunkSize;
            int offset = 0;
            MDfromHTMLIPCMessage msg = null;
            for (int seq = 1; seq <= chunks; ++seq) {
                offset = (seq - 1) * chunkSize;
                msg = new MDfromHTMLIPCMessage(this._publisherName, this._sessionID, this._appl, this._topic, this._type, this._verb, this._userID, Arrays.copyOfRange(this._message, offset, seq * chunkSize));
                msg.setTime(this._createTime);
                msg.setSequence(seq);
                list.add(msg);
            }
            if (this._message.length % chunkSize != 0) {
                offset = chunks * chunkSize;
                msg = new MDfromHTMLIPCMessage(this._publisherName, this._sessionID, this._appl, this._topic, this._type, this._verb, this._userID, Arrays.copyOfRange(this._message, offset, this._message.length));
                msg.setTime(this._createTime);
                msg.setSequence(Integer.MAX_VALUE);
                list.add(msg);
            } else {
                super.setSequence(Integer.MAX_VALUE);
            }
        }
        return list.toArray(new MDfromHTMLIPCMessage[0]);
    }

    @Override
    public MDfromHTMLID getSessionID() {
        return this._sessionID;
    }

    @Override
    public long getTime() {
        return this._createTime;
    }

    @Override
    public String getTopic() {
        return this._topic;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public MDfromHTMLIPCVerbs getVerb() {
        return this._verb;
    }

    @Override
    public MDfromHTMLID getUserID() {
        return this._userID;
    }

    @Override
    public int getVerbValue() {
        return this._verb.getValue();
    }

    @Override
    public boolean isJSON() {
        return this._isJSON;
    }

    @Override
    public boolean isLastMessage() {
        return this._seqnum == Integer.MAX_VALUE;
    }

    @Override
    public boolean isOnlyMessage() {
        return this._seqnum == 0;
    }

    @Override
    public boolean isSequence() {
        return this._seqnum != 0;
    }

    private void setApplication(MDfromHTMLIPCApplications application) {
        if (application == null) {
            this._appl = MDfromHTMLIPCApplications.UNDEFINED;
            return;
        }
        this._appl = application;
    }

    public void setMessage(JSONObject message) {
        if (MDfromHTMLUtils.isUndefined(message)) {
            message = new JSONObject();
        }
        this._message = MDfromHTMLUtils.toUTF8Bytes(message.toString());
        this._isJSON = true;
    }

    private void setMessageBytes(byte[] bytes) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        this._message = bytes;
        this._isJSON = this.checkIsJSON(this._message);
    }

    private void setPublisherName(String publisherName) {
        if (MDfromHTMLUtils.isUndefined(publisherName)) {
            publisherName = new MDfromHTMLID().toString();
        }
        this._publisherName = publisherName;
    }

    private void setSequence(int seqnum) {
        this._seqnum = seqnum;
    }

    private void setSessionID(MDfromHTMLID sessionID) {
        if (MDfromHTMLID.isUndefined(sessionID)) {
            sessionID = MDfromHTMLID.UNDEFINED_ID;
        }
        this._sessionID = sessionID;
    }

    private void setTime(long time) {
        this._createTime = time;
    }

    private void setTopic(String topic) {
        if (MDfromHTMLUtils.isUndefined(topic)) {
            topic = "MDfromHTML";
        }
        this._topic = topic;
    }

    private void setType(String type) {
        if (MDfromHTMLUtils.isUndefined(type)) {
            type = "?";
        }
        this._type = type;
    }

    private void setVerb(MDfromHTMLIPCVerbs verb) {
        if (verb == null) {
            this._verb = MDfromHTMLIPCVerbs.UNDEFINED;
            return;
        }
        this._verb = verb;
    }

    private void setUserID(MDfromHTMLID userID) {
        if (MDfromHTMLID.isUndefined(userID)) {
            userID = MDfromHTMLID.UNDEFINED_ID;
        }
        this._userID = userID;
    }

    @Override
    public String toStringFull() {
        return this.toStringFull(true);
    }

    @Override
    public String toStringFull(boolean formatJSON) {
        StringBuffer sb = new StringBuffer();
        sb.append("SessionID:");
        sb.append(this._sessionID);
        sb.append(", Appl:");
        sb.append(this._appl.name());
        sb.append(" Topic:");
        sb.append(this._topic);
        sb.append(", Type:");
        sb.append(this._type);
        sb.append(", Verb:");
        sb.append(this._verb.name());
        sb.append(", UserID:");
        sb.append(this._userID);
        sb.append(", Publisher:");
        sb.append(this._publisherName);
        sb.append(", Time:");
        sb.append(new MDfromHTMLDate(this._createTime).toStringDateTime());
        sb.append(", Seq:");
        sb.append(this._seqnum);
        sb.append(", isJSON:");
        sb.append(this._isJSON);
        sb.append(", isLast:");
        sb.append(this.isLastMessage());
        sb.append(", isOnly:");
        sb.append(this.isOnlyMessage());
        sb.append("\nmsg:");
        if (this.isJSON()) {
            try {
                try {
                    sb.append(this.getMessage().serialize(formatJSON));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            sb.append("0x");
            sb.append(MDfromHTMLUtils.hexEncode(this._message));
        }
        return sb.toString();
    }

    public String toHdrString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SessionID:");
        sb.append(this._sessionID);
        sb.append(", Appl:");
        sb.append(this._appl.name());
        sb.append(" Topic:");
        sb.append(this._topic);
        sb.append(", Type:");
        sb.append(this._type);
        sb.append(", Verb:");
        sb.append(this._verb.name());
        sb.append(", UserID:");
        sb.append(this._userID);
        sb.append(", Publisher:");
        sb.append(this._publisherName);
        sb.append(", Time:");
        sb.append(new MDfromHTMLDate(this._createTime).toStringDateTime());
        sb.append(", Seq:");
        sb.append(this._seqnum);
        sb.append(", isJSON:");
        sb.append(this._isJSON);
        sb.append(", isLast:");
        sb.append(this.isLastMessage());
        sb.append(", isOnly:");
        sb.append(this.isOnlyMessage());
        return sb.toString();
    }

    public String toStringHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append(" Time: ");
        sb.append(new MDfromHTMLDate(this._createTime).toStringDateTime());
        sb.append(", Seq:");
        sb.append(this._seqnum);
        sb.append(", Publisher:");
        sb.append(this._publisherName);
        sb.append(", SessionID:");
        sb.append(this._sessionID);
        sb.append(",\n   Topic:");
        sb.append(this._topic);
        sb.append(", Type:");
        sb.append(this._type);
        sb.append(", Verb:");
        sb.append(this._verb.name());
        sb.append(", UserID:");
        sb.append(this._userID);
        sb.append(", isJSON:");
        sb.append(this._isJSON);
        sb.append(", isLast:");
        sb.append(this.isLastMessage());
        sb.append(", isOnly:");
        sb.append(this.isOnlyMessage());
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" Time: ");
        sb.append(new MDfromHTMLDate(this._createTime).toStringDateTime());
        sb.append(", Seq:");
        sb.append(this._seqnum);
        sb.append(", Publisher:");
        sb.append(this._publisherName);
        sb.append(", SessionID:");
        sb.append(this._sessionID);
        sb.append(",\n   Topic:");
        sb.append(this._topic);
        sb.append(", Type:");
        sb.append(this._type);
        sb.append(", Verb:");
        sb.append(this._verb.name());
        sb.append(", UserID:");
        sb.append(this._userID);
        sb.append(", isJSON:");
        sb.append(this._isJSON);
        sb.append(", isLast:");
        sb.append(this.isLastMessage());
        sb.append(", isOnly:");
        sb.append(this.isOnlyMessage());
        sb.append("\nmsg:");
        String text = "";
        if (this.isJSON()) {
            try {
                text = this.getMessage().toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            text = "0x" + MDfromHTMLUtils.hexEncode(this._message);
        }
        sb.append(MDfromHTMLUtils.shortenString(text, 100));
        return sb.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("sessionID", (Object)this._sessionID.toString());
        jsonObj.put("appl", (Object)this._appl.name());
        jsonObj.put("topic", (Object)this._topic);
        jsonObj.put("type", (Object)this._type);
        jsonObj.put("verb", (Object)this._verb.name());
        jsonObj.put("userID", (Object)this._userID.toString());
        jsonObj.put("publisher", (Object)this._publisherName);
        jsonObj.put("time", (Object)new MDfromHTMLDate(this._createTime).toStringDateTime());
        jsonObj.put("seq", (Object)new Long(this._seqnum));
        jsonObj.put("isJSON", (Object)this._isJSON);
        jsonObj.put("isLast", (Object)this.isLastMessage());
        jsonObj.put("isOnly", (Object)this.isOnlyMessage());
        try {
            jsonObj.put("msg", this.isJSON() ? this.getMessage() : "0x" + MDfromHTMLUtils.hexEncode(this._message));
        }
        catch (Exception e) {
            jsonObj.put("msg", (Object)("0x" + MDfromHTMLUtils.hexEncode(this._message)));
        }
        return jsonObj;
    }

    static {
        IPC_MAX_MESSAGE_SIZE = MDfromHTMLIPCMessage.getIPCMaxMessageSize();
    }
}

