/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.core;

import com.api.json.JSONArray;
import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLCrypto;
import com.mdfromhtml.core.MDfromHTMLUtils;
import java.util.Set;

public class MDfromHTMLMasker {
    public static final String ENV_MASKER_KEY = "MDfromHTML_MaskerKey";
    static boolean s_debug = false;

    public static void main(String[] args) {
        try {
            String value;
            while ((value = MDfromHTMLUtils.prompt("Enter value to be masked or q to quit:")).length() != 0 && !"q".equalsIgnoreCase(value)) {
                if (value.startsWith("d3cry9t:")) {
                    System.out.println("Unmasked version of " + value + " is:\n" + MDfromHTMLMasker.unmask(value.substring(8)));
                    continue;
                }
                System.out.println("Masked version of " + value + " is:\n" + MDfromHTMLMasker.mask(value));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Goodbye");
    }

    public static String mask(String unmaskedText) throws Exception {
        return MDfromHTMLCrypto.encrypt(unmaskedText);
    }

    public static JSONArray maskArray(JSONArray array) throws Exception {
        if (array == null) {
            return null;
        }
        JSONArray newArray = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            Object value = array.get(i);
            if (value instanceof String) {
                value = MDfromHTMLMasker.mask((String)value);
            } else if (value instanceof JSONObject) {
                value = MDfromHTMLMasker.maskObject((JSONObject)value);
            } else if (value instanceof JSONArray) {
                value = MDfromHTMLMasker.maskArray((JSONArray)value);
            }
            newArray.add(value);
            if (!s_debug) continue;
            System.out.println("pushed =" + value);
        }
        return newArray;
    }

    public static JSONObject maskObject(JSONObject object) throws Exception {
        if (object == null) {
            return null;
        }
        Set keyset = object.keySet();
        String[] keys = keyset.toArray(new String[0]);
        JSONObject newObj = new JSONObject();
        for (int i = 0; i < keys.length; ++i) {
            Object value = object.get((Object)keys[i]);
            if (value instanceof String) {
                value = MDfromHTMLMasker.mask((String)value);
            } else if (value instanceof JSONObject) {
                value = MDfromHTMLMasker.maskObject((JSONObject)value);
            } else if (value instanceof JSONArray) {
                value = MDfromHTMLMasker.maskArray((JSONArray)value);
            }
            newObj.put(keys[i], value);
            if (!s_debug) continue;
            System.out.println("processed " + keys[i] + "=" + value);
        }
        return newObj;
    }

    public static String unmask(String maskedText) throws Exception {
        return MDfromHTMLCrypto.decrypt(maskedText, new String(MDfromHTMLUtils.getKey()));
    }

    public static JSONArray unmaskArray(JSONArray array) throws Exception {
        if (array == null) {
            return null;
        }
        JSONArray newArray = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            Object value = array.get(i);
            if (value instanceof String) {
                value = MDfromHTMLMasker.unmask((String)value);
            } else if (value instanceof JSONObject) {
                value = MDfromHTMLMasker.unmaskObject((JSONObject)value);
            } else if (value instanceof JSONArray) {
                value = MDfromHTMLMasker.unmaskArray((JSONArray)value);
            }
            newArray.add(value);
            if (!s_debug) continue;
            System.out.println("pushed =" + value);
        }
        return newArray;
    }

    public static JSONObject unmaskObject(JSONObject object) throws Exception {
        if (object == null) {
            return null;
        }
        Set keyset = object.keySet();
        String[] keys = keyset.toArray(new String[0]);
        JSONObject newObj = new JSONObject();
        for (int i = 0; i < keys.length; ++i) {
            Object value = object.get((Object)keys[i]);
            if (value instanceof String) {
                value = MDfromHTMLMasker.unmask((String)value);
            } else if (value instanceof JSONObject) {
                value = MDfromHTMLMasker.unmaskObject((JSONObject)value);
            } else if (value instanceof JSONArray) {
                value = MDfromHTMLMasker.unmaskArray((JSONArray)value);
            }
            newObj.put(keys[i], value);
            if (!s_debug) continue;
            System.out.println("processed " + keys[i] + "=" + value);
        }
        return newObj;
    }
}

