/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.core;

import com.mdfromhtml.core.MDfromHTMLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class MDfromHTMLCrypto {
    private static final String REVERSE = "d3cry9t:";
    public static final byte[] SALT = new byte[]{-2, 49, 18, 23, -34, 83, 22, 37};

    private static byte[] base64Decode(String property) throws IOException {
        return Base64.getUrlDecoder().decode(property);
    }

    private static String base64Encode(byte[] bytes) {
        return Base64.getUrlEncoder().encodeToString(bytes);
    }

    public static String decrypt(String text, char[] key, byte[] salt) throws Exception {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            SecretKey secretKey = keyFactory.generateSecret(new PBEKeySpec(key));
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(2, (Key)secretKey, new PBEParameterSpec(salt, 20));
            return new String(pbeCipher.doFinal(MDfromHTMLCrypto.base64Decode(text)), "UTF-8");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("Can not find needed algorithm: " + e.getLocalizedMessage(), e);
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("Invalid key specification: " + e.getLocalizedMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new Exception("Missing padding: " + e.getLocalizedMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new Exception("Invalid key: " + e.getLocalizedMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new Exception("Invalid algorithm parameter: " + e.getLocalizedMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("Unsupported encoding: " + e.getLocalizedMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("Illegal block size: " + e.getLocalizedMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new Exception("Bad padding: " + e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new Exception("IO Exception: " + e.getLocalizedMessage(), e);
        }
    }

    public static String decrypt(String text, String key) throws Exception {
        if (!new String(MDfromHTMLUtils.getKey()).equals(key)) {
            throw new Exception("Property or Password is invalid");
        }
        return MDfromHTMLCrypto.decrypt(text, MDfromHTMLUtils.getKey(), SALT);
    }

    public static String encrypt(String text) throws Exception {
        return MDfromHTMLCrypto.encrypt(text, MDfromHTMLUtils.getKey(), SALT);
    }

    public static String encrypt(String text, char[] key, byte[] salt) throws Exception {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            SecretKey secretKey = keyFactory.generateSecret(new PBEKeySpec(key));
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(1, (Key)secretKey, new PBEParameterSpec(salt, 20));
            return MDfromHTMLCrypto.base64Encode(pbeCipher.doFinal(text.getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("Can not find needed algorithm: " + e.getLocalizedMessage(), e);
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("Invalid key specification: " + e.getLocalizedMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new Exception("Missing padding: " + e.getLocalizedMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new Exception("Invalid key: " + e.getLocalizedMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new Exception("Invalid algorithm parameter: " + e.getLocalizedMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("Unsupported encoding: " + e.getLocalizedMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("Illegal block size: " + e.getLocalizedMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new Exception("Bad padding: " + e.getLocalizedMessage(), e);
        }
    }

    public static void main(String[] args) throws Exception {
        String originalText = "secret";
        while ((originalText = MDfromHTMLUtils.prompt("Enter text to be masked, or nothing to quit:", true)).length() != 0) {
            if (!originalText.startsWith(REVERSE)) {
                System.out.println("Original text: " + originalText);
                String maskedText = MDfromHTMLCrypto.encrypt(originalText);
                System.out.println("Masked text: " + maskedText);
                String unmaskedText = MDfromHTMLCrypto.decrypt(maskedText, MDfromHTMLUtils.getKey().toString());
                System.out.println("Unmasked text: " + unmaskedText);
                continue;
            }
            originalText = originalText.substring(REVERSE.length());
            System.out.println("Masked text: " + originalText);
            String unmaskedText = MDfromHTMLCrypto.decrypt(originalText, MDfromHTMLUtils.getKey().toString());
            System.out.println("Unmasked text: " + unmaskedText);
        }
        System.out.println("Goodbye");
    }
}

