/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.core;

import com.mdfromhtml.core.MDfromHTMLUtils;
import java.io.Serializable;
import java.util.Base64;
import java.util.UUID;

public class MDfromHTMLID
implements Serializable,
Comparable<Object>,
Cloneable {
    public static int ID_LENGTH = 22;
    public static final String ID_UNDEFINED = "??????????????????????";
    private static final long serialVersionUID = 2726688498762622537L;
    public static final MDfromHTMLID UNDEFINED_ID = new MDfromHTMLID();
    public static final String val_safe = new String("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_=");
    private String _id = "??????????????????????";

    public static MDfromHTMLID generateNewID() {
        return new MDfromHTMLID();
    }

    public static MDfromHTMLID getExistingID(String uuid) {
        if (uuid != null && uuid.length() == ID_LENGTH) {
            byte[] uuidBytes;
            if (uuid.compareTo(ID_UNDEFINED) == 0) {
                return UNDEFINED_ID;
            }
            for (byte uuidByte : uuidBytes = uuid.getBytes()) {
                if (val_safe.indexOf(uuidByte) != -1) continue;
                return UNDEFINED_ID;
            }
            MDfromHTMLID id = new MDfromHTMLID(uuid);
            return id;
        }
        return UNDEFINED_ID;
    }

    public static boolean isUndefined(MDfromHTMLID test) {
        if (test == null) {
            return true;
        }
        return test.isUndefined();
    }

    public static void main(String[] args) {
        String quit;
        if (!MDfromHTMLID.isUndefined(MDfromHTMLID.getExistingID("too_small"))) {
            System.out.println("Error for \"too_small\"");
        } else if (!MDfromHTMLID.isUndefined(MDfromHTMLID.getExistingID("much_much_much_much_too_long"))) {
            System.out.println("Error for \"much_much_much_much_too_long\"");
        } else if (!MDfromHTMLID.isUndefined(MDfromHTMLID.getExistingID("bad char______________"))) {
            System.out.println("Error for \"bad char______________\"");
        } else if (!MDfromHTMLID.isUndefined(MDfromHTMLID.getExistingID(ID_UNDEFINED))) {
            System.out.println("Error for \"??????????????????????\"");
        } else if (MDfromHTMLID.isUndefined(MDfromHTMLID.getExistingID("ABCDEFGHIJKLMNOPQRSTUV"))) {
            System.out.println("Error for \"ABCDEFGHIJKLMNOPQRSTUV\"");
        } else {
            System.out.println("Everything is okay.");
        }
        while ("quit".compareToIgnoreCase(quit = MDfromHTMLUtils.prompt("Enter quit to exit:")) != 0) {
            System.out.println("MDfromHTMLID: \"" + MDfromHTMLID.generateNewID() + "\"");
        }
        System.out.println("Goodbye");
    }

    public MDfromHTMLID() {
        this._id = this.getUUID();
    }

    private MDfromHTMLID(String uuid) {
        this._id = uuid;
    }

    public MDfromHTMLID clone() {
        return MDfromHTMLID.getExistingID(this._id);
    }

    @Override
    public int compareTo(Object o) {
        if (o == null) {
            o = UNDEFINED_ID;
        }
        if (o instanceof MDfromHTMLID) {
            return this._id.compareTo(((MDfromHTMLID)o).toString());
        }
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (MDfromHTMLID.class.isInstance(obj)) {
            if (!this.isUndefined() && this._id.equals(((MDfromHTMLID)obj)._id)) {
                return true;
            }
            if (this.isUndefined() && MDfromHTMLID.isUndefined((MDfromHTMLID)obj)) {
                return true;
            }
        }
        return false;
    }

    private String getUUID() {
        int i;
        UUID uuid = UUID.randomUUID();
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] bUUID = new byte[16];
        for (i = 0; i < 8; ++i) {
            bUUID[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            bUUID[i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return Base64.getUrlEncoder().encodeToString(bUUID).substring(0, 22);
    }

    public int hashCode() {
        if (this._id != null && this._id.trim().length() != 0 && this._id.compareTo("?") != 0) {
            return this._id.hashCode();
        }
        return 0;
    }

    public boolean isUndefined() {
        return ID_UNDEFINED.equals(this._id);
    }

    public String toString() {
        return this._id;
    }

    static {
        MDfromHTMLID.UNDEFINED_ID._id = ID_UNDEFINED;
    }
}

