/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.core;

import com.api.json.JSON;
import com.api.json.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mdfromhtml.core.MDfromHTMLUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Iterator;

public class MDfromHTMLComms {
    static boolean s_debug = false;
    static Gson s_gson = new GsonBuilder().create();

    public static JSONObject sendRequest(String method, JSONObject service, JSONObject params) throws Exception {
        JsonObject serviceObj = s_gson.fromJson(service.toString(), JsonObject.class);
        JsonObject parameters = s_gson.fromJson(params.toString(), JsonObject.class);
        return (JSONObject)JSON.parse(MDfromHTMLComms.sendRequest(method, serviceObj, parameters).toString());
    }

    public static ObjectNode sendRequest(String method, ObjectNode serviceObj, ObjectNode params) throws Exception {
        JsonObject parameters = s_gson.fromJson(params.toString(), JsonObject.class);
        return MDfromHTMLComms.sendRequest(method, serviceObj, parameters);
    }

    public static JsonObject sendRequest(String method, JsonObject serviceObj, JsonObject params) throws Exception {
        if (method == null) {
            throw new Exception("The method is null.");
        }
        if (serviceObj == null) {
            throw new Exception("The serviceObj is null");
        }
        if (params == null) {
            throw new Exception("The params object is null");
        }
        ObjectNode service = (ObjectNode)new ObjectMapper().readTree(serviceObj.toString());
        ObjectNode response = MDfromHTMLComms.sendRequest(method, service, params);
        return s_gson.fromJson(response.toString(), JsonObject.class);
    }

    public static ObjectNode sendRequest(String method, ObjectNode serviceObj, JsonObject params) throws Exception {
        if (method == null) {
            throw new Exception("The method is null.");
        }
        if (serviceObj == null) {
            throw new Exception("The serviceObj is null");
        }
        if (params == null) {
            throw new Exception("The params object is null");
        }
        String protocol = MDfromHTMLComms.getStringFromObject(serviceObj, "protocol").trim();
        String domain = MDfromHTMLComms.getStringFromObject(serviceObj, "domain").trim();
        JsonNode portnumberElt = serviceObj.get("portnumber");
        if (portnumberElt == null) {
            throw new Exception("The portnumber in the service is missing.");
        }
        String portnumber = "";
        if (!portnumberElt.isValueNode()) {
            throw new Exception("The portnumber is not a String of a number, nor a Number.");
        }
        portnumber = portnumberElt.asText().trim();
        String endpoint = MDfromHTMLComms.getStringFromObject(serviceObj, "endpoint", "").trim();
        String username = MDfromHTMLComms.getStringFromObject(serviceObj, "username").trim();
        String password = MDfromHTMLComms.getStringFromObject(serviceObj, "password").trim();
        String apitimeout = MDfromHTMLComms.getStringFromObject(serviceObj, "apitimeout").trim();
        return MDfromHTMLComms.sendRequest(method, protocol, domain, portnumber, endpoint, username, password, apitimeout, params);
    }

    public static ObjectNode sendRequest(String method, String protocol, String domain, String portnumber, String endpoint, String username, String password, String apitimeout, JsonObject params) throws Exception {
        if (method == null) {
            throw new Exception("The method is null.");
        }
        if ((method = method.trim()).length() == 0) {
            throw new Exception("The method is empty.");
        }
        if (params == null) {
            throw new Exception("The params object is null");
        }
        int timeout = 10000;
        try {
            timeout = new Integer(apitimeout);
            if (timeout < 0) {
                throw new Exception("The apitimeout is less than zero milliseconds.");
            }
        }
        catch (NumberFormatException nfe) {
            throw new Exception("The apitimeout is not a positive integer of milliseconds.");
        }
        ObjectNode responseObj = null;
        String url = protocol + "://" + domain;
        if (portnumber != null && portnumber.length() > 0) {
            url = url + ":" + portnumber;
        }
        boolean needsQuestionMark = endpoint.indexOf("?") == -1;
        url = url + endpoint;
        if ("GET".equals(method)) {
            String key = null;
            boolean first = true;
            StringBuffer sb = new StringBuffer();
            if (params.size() > 0) {
                Iterator<String> it = params.keySet().iterator();
                while (it.hasNext()) {
                    if (first) {
                        if (needsQuestionMark) {
                            sb.append("?");
                        } else {
                            sb.append("&");
                        }
                        first = false;
                    } else {
                        sb.append("&");
                    }
                    key = it.next();
                    sb.append(key);
                    sb.append("=");
                    JsonElement value = params.get(key);
                    sb.append(s_gson.toJson(value));
                }
                url = url + URLEncoder.encode(sb.toString(), "UTF-8");
            }
        }
        if (s_debug) {
            System.out.println("URL: " + url);
        }
        URL obj = new URL(url);
        HttpURLConnection.setFollowRedirects(true);
        HttpURLConnection serviceConnection = (HttpURLConnection)obj.openConnection();
        serviceConnection.setRequestMethod(method);
        if (username != null && password != null) {
            String auth = username + ":" + password;
            byte[] authEncBytes = Base64.getEncoder().encode(auth.getBytes());
            String authStringEnc = new String(authEncBytes);
            authStringEnc = "Basic " + authStringEnc;
            serviceConnection.setRequestProperty("Authorization", authStringEnc);
        }
        serviceConnection.setRequestProperty("Content-Type", "application/json");
        serviceConnection.setDoOutput(true);
        OutputStream os = serviceConnection.getOutputStream();
        serviceConnection.setConnectTimeout(timeout);
        if ("GET".equals(method)) {
            os.write(new byte[0]);
        } else {
            os.write(params.toString().getBytes());
        }
        os.flush();
        os.close();
        int responseCode = serviceConnection.getResponseCode();
        String responseMsg = serviceConnection.getResponseMessage();
        if (s_debug) {
            System.out.println("Returned code " + responseCode + " " + responseMsg);
        }
        if (responseCode >= 200 && responseCode < 299) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(serviceConnection.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode responseNode = mapper.readTree(response.toString());
            if (responseNode.isObject()) {
                responseObj = (ObjectNode)responseNode;
            }
        } else {
            responseObj = JsonNodeFactory.instance.objectNode();
            responseObj.put("errorCode", responseCode);
            responseObj.put("errorMsg", responseMsg);
        }
        return responseObj;
    }

    public static ArrayNode getArrayFromObject(ObjectNode obj, String key) throws Exception {
        JsonNode test = obj.get(key);
        if (test == null) {
            throw new Exception("The " + key + " is missing.");
        }
        if (test.isArray()) {
            return (ArrayNode)test;
        }
        throw new Exception("The value for " + key + " is not an Array.");
    }

    public static boolean getBooleanFromObject(ObjectNode obj, String key) throws Exception {
        JsonNode test = obj.get(key);
        if (test == null) {
            throw new Exception("The " + key + " is missing.");
        }
        if (test.isBoolean()) {
            return test.asBoolean();
        }
        throw new Exception("The value for " + key + " is not a Boolean.");
    }

    public static ObjectNode getNonNullObjectFromNode(JsonNode node) throws Exception {
        if (node == null) {
            throw new Exception("Node is null.");
        }
        if (node.isObject()) {
            return (ObjectNode)node;
        }
        throw new Exception("Node is not an object.");
    }

    public static ObjectNode getObjectFromObject(ObjectNode obj, String key) throws Exception {
        JsonNode test = obj.get(key);
        if (test == null) {
            throw new Exception("The " + key + " is missing.");
        }
        if (test.isObject()) {
            return (ObjectNode)test;
        }
        throw new Exception("The value for " + key + " is not an Object.");
    }

    public static String getStringFromObject(ObjectNode obj, String key) throws Exception {
        JsonNode test = obj.get(key);
        if (test == null) {
            throw new Exception("The " + key + " is missing.");
        }
        if (test.isTextual()) {
            return test.asText();
        }
        throw new Exception("The value for " + key + " is not a String.");
    }

    public static String getStringFromObject(ObjectNode obj, String key, String defaultValue) throws Exception {
        try {
            return MDfromHTMLComms.getStringFromObject(obj, key);
        }
        catch (Exception e) {
            if (e.getLocalizedMessage().endsWith("is missing.")) {
                return defaultValue;
            }
            throw e;
        }
    }

    public static void main(String[] args) {
        String username = MDfromHTMLUtils.prompt("Enter username:");
        String password = MDfromHTMLUtils.prompt("Enter password:");
        byte[] authEncBytes = Base64.getEncoder().encode((username + ":" + password).getBytes());
        String authStringEnc = new String(authEncBytes);
        System.out.println("Authorization: Basic " + authStringEnc);
    }
}

