/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.JSONataUtils;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Objects;

public class PadFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = 5849324073360601941L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$pad");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$pad");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$pad");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$pad");
    public static String ERR_ARG4BADTYPE = String.format("Argument 4 of function %s does not match function signature", "$pad");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        NullNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = PadFunction.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            if (argString != null && !argString.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 2 && argCount != 3) throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : (argCount == 1 ? ERR_ARG1BADTYPE : ERR_ARG4BADTYPE));
        if (!useContext) {
            argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        JsonNode argWidth = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
        if (argString == null) {
            return null;
        }
        if (!argString.isTextual()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        String str = argString.textValue();
        int width = 0;
        if (argWidth == null) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        if (!argWidth.isNumber()) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        width = argWidth.asInt();
        String padStr = " ";
        if (argCount == 3) {
            JsonNode argChar = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 1 : 2);
            if (argChar == null) throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
            if (!argChar.isTextual()) throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
            padStr = argChar.asText();
        }
        if (width >= 0) return new TextNode(PadFunction.rightPad(str, width, padStr));
        return new TextNode(PadFunction.leftPad(str, -width, padStr));
    }

    public static String leftPad(String str, int size, String padStr) {
        int pads;
        if (str == null) {
            return null;
        }
        if (padStr == null) {
            padStr = " ";
        }
        String strData = Objects.requireNonNull(str).intern();
        int strLen = strData.codePointCount(0, strData.length());
        String padData = Objects.requireNonNull(padStr).intern();
        int padLen = padData.codePointCount(0, padData.length());
        if (padLen == 0) {
            padStr = " ";
        }
        if ((pads = size - strLen) <= 0) {
            return str;
        }
        String padding = "";
        for (int i = 0; i < pads + 1; ++i) {
            padding = padding + padStr;
        }
        return JSONataUtils.substr(padding, 0, pads).concat(str);
    }

    public static String rightPad(String str, int size, String padStr) {
        int pads;
        if (str == null) {
            return null;
        }
        if (padStr == null) {
            padStr = " ";
        }
        String strData = Objects.requireNonNull(str).intern();
        int strLen = strData.codePointCount(0, strData.length());
        String padData = Objects.requireNonNull(padStr).intern();
        int padLen = padData.codePointCount(0, padData.length());
        if (padLen == 0) {
            padStr = " ";
        }
        if ((pads = size - strLen) <= 0) {
            return str;
        }
        String padding = "";
        for (int i = 0; i < pads + 1; ++i) {
            padding = padding + padStr;
        }
        return str.concat(JSONataUtils.substr(padding, 0, pads));
    }

    @Override
    public int getMaxArgs() {
        return 3;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<s-ns?:s>";
    }
}

