/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.util;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.impl.JobControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;

public class BatchWorkUnit
implements Runnable {
    private String CLASSNAME = BatchWorkUnit.class.getName();
    private Logger logger = Logger.getLogger(BatchWorkUnit.class.getPackage().getName());
    private RuntimeJobExecutionImpl jobExecutionImpl = null;
    private IBatchKernelService batchKernel = null;
    private final JobControllerImpl controller;
    private LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue;
    private Stack<String> subJobExitStatusQueue;
    private boolean notifyCallbackWhenDone;

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeJobExecutionImpl jobExecutionImpl) {
        this(batchKernel, jobExecutionImpl, null, null, true);
    }

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeJobExecutionImpl jobExecutionImpl, LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue, Stack<String> subJobExitStatusQueue, boolean notifyCallbackWhenDone) {
        this.setBatchKernel(batchKernel);
        this.setJobExecutionImpl(jobExecutionImpl);
        this.setAnalyzerQueue(analyzerQueue);
        this.setSubJobExitStatus(subJobExitStatusQueue);
        this.setNotifyCallbackWhenDone(notifyCallbackWhenDone);
        this.controller = new JobControllerImpl(this.getJobExecutionImpl());
        this.controller.setAnalyzerQueue(this.analyzerQueue);
        this.controller.setSubJobExitStatusQueue(subJobExitStatusQueue);
    }

    public JobControllerImpl getController() {
        return this.controller;
    }

    @Override
    public void run() {
        String method = "run";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.CLASSNAME, method);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("==========================================================");
            this.logger.fine("Invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
            this.logger.fine("==========================================================");
        }
        try {
            this.controller.executeJob();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Exception when invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
                this.logger.fine("Job Batch Status = " + this.getBatchStatus() + ";  Job Exit Status = " + this.getExitStatus());
            }
            if (this.isNotifyCallbackWhenDone()) {
                this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
            }
            throw new BatchContainerRuntimeException("This job failed unexpectedly.", e);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("==========================================================");
            this.logger.fine("Done invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
            this.logger.fine("Job Batch Status = " + this.getBatchStatus() + ";  Job Exit Status = " + this.getExitStatus());
            this.logger.fine("==========================================================");
        }
        if (this.isNotifyCallbackWhenDone()) {
            this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.CLASSNAME, method);
        }
    }

    private JobOperator.BatchStatus getBatchStatus() {
        return this.jobExecutionImpl.getJobContext().getBatchStatus();
    }

    private String getExitStatus() {
        return this.jobExecutionImpl.getJobContext().getExitStatus();
    }

    public void setBatchKernel(IBatchKernelService batchKernel) {
        this.batchKernel = batchKernel;
    }

    public IBatchKernelService getBatchKernel() {
        return this.batchKernel;
    }

    public void setJobExecutionImpl(RuntimeJobExecutionImpl jobExecutionImpl) {
        this.jobExecutionImpl = jobExecutionImpl;
    }

    public RuntimeJobExecutionImpl getJobExecutionImpl() {
        return this.jobExecutionImpl;
    }

    public void setNotifyCallbackWhenDone(boolean notifyCallbackWhenDone) {
        this.notifyCallbackWhenDone = notifyCallbackWhenDone;
    }

    public boolean isNotifyCallbackWhenDone() {
        return this.notifyCallbackWhenDone;
    }

    public LinkedBlockingQueue<PartitionDataWrapper> getAnalyzerQueue() {
        return this.analyzerQueue;
    }

    public void setAnalyzerQueue(LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue) {
        this.analyzerQueue = analyzerQueue;
    }

    public Stack<String> getSubJobExitStatusQueue() {
        return this.subJobExitStatusQueue;
    }

    public void setSubJobExitStatus(Stack<String> subJobExitStatusQueue2) {
        this.subJobExitStatusQueue = subJobExitStatusQueue2;
    }
}

