/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.services.IJobStatusManagerService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.JobStatus;
import com.ibm.jbatch.container.status.JobStatusKey;
import com.ibm.jbatch.container.status.StepStatus;
import com.ibm.jbatch.container.status.StepStatusKey;
import com.ibm.jbatch.spi.services.IBatchConfig;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.JobInstance;

public class JobStatusManagerImpl
implements IJobStatusManagerService {
    private static final String CLASSNAME = JobStatusManagerImpl.class.getName();
    private static Logger logger = Logger.getLogger(JobStatusManagerImpl.class.getPackage().getName());
    private IPersistenceManagerService _persistenceManager;
    private String _jobId;

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    @Override
    public JobStatus createJobStatus(JobInstance jobInstance, long firstJobExecutionId) throws BatchContainerServiceException {
        String method = "createJobStatus";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASSNAME, method, " jobid: " + jobInstance.getInstanceId());
        }
        JobStatus jobStatus = new JobStatus(jobInstance);
        jobStatus.setLatestExecutionId(firstJobExecutionId);
        this._persistenceManager.createData(0, new JobStatusKey(jobInstance.getInstanceId()), jobStatus);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASSNAME, method);
        }
        return jobStatus;
    }

    @Override
    public JobStatus getJobStatus(long jobInstanceId) throws BatchContainerServiceException {
        JobStatus retVal = null;
        List data = this._persistenceManager.getData(0, new JobStatusKey(jobInstanceId));
        if (data == null) {
            throw new IllegalStateException("Null entry for JobInstance: " + jobInstanceId);
        }
        if (data.size() == 0) {
            throw new IllegalStateException("Empty entry for JobInstance: " + jobInstanceId);
        }
        if (data.size() != 1) {
            throw new IllegalStateException("Should only be one entry for JobInstance: " + jobInstanceId);
        }
        try {
            retVal = (JobStatus)data.get(0);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Expected JobStatus but found" + data.get(0));
        }
        return retVal;
    }

    @Override
    public void updateJobBatchStatus(long jobInstanceId, JobOperator.BatchStatus batchStatus) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setBatchStatus(batchStatus);
        this.persistJobStatus(jobInstanceId, js);
    }

    @Override
    public void updateJobExecutionStatus(long jobInstanceId, JobOperator.BatchStatus batchStatus, String exitStatus) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setBatchStatus(batchStatus);
        js.setExitStatus(exitStatus);
        this.persistJobStatus(jobInstanceId, js);
    }

    @Override
    public void updateJobCurrentStep(long jobInstanceId, String currentStepName) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setCurrentStepId(currentStepName);
        this.persistJobStatus(jobInstanceId, js);
    }

    @Override
    public void updateJobStatusWithNewExecution(long jobInstanceId, long newExecutionId) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setLatestExecutionId(newExecutionId);
        this.persistJobStatus(jobInstanceId, js);
    }

    private void persistJobStatus(long jobInstanceId, JobStatus newJobStatus) throws BatchContainerServiceException {
        this._persistenceManager.updateData(0, new JobStatusKey(jobInstanceId), newJobStatus);
    }

    @Override
    public void createStepStatus(long jobInstanceId, String stepId, StepStatus newStepStatus) throws BatchContainerServiceException {
        this._persistenceManager.createData(1, new StepStatusKey(jobInstanceId, stepId), newStepStatus);
    }

    @Override
    public StepStatus getStepStatus(long jobInstanceId, String stepId) throws BatchContainerServiceException {
        String method = "getStepStatus";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASSNAME, method, " jobid: " + jobInstanceId + ", stepId: " + stepId);
        }
        StepStatus retVal = null;
        List data = this._persistenceManager.getData(1, new StepStatusKey(jobInstanceId, stepId));
        if (data.size() == 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(CLASSNAME, method, "No step status found in store.");
            }
            return null;
        }
        if (data.size() > 1) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(CLASSNAME, method, "Found more than 1 (number=" + data.size() + ") StepStatus in store.");
            }
            throw new IllegalStateException("Should only be one entry for job/step with JobInstance: " + jobInstanceId + ", and step id = " + stepId);
        }
        try {
            retVal = (StepStatus)data.get(0);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Expected JobStatus but found" + data.get(0));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASSNAME, method, "Found step status in store: " + retVal);
        }
        return retVal;
    }

    @Override
    public void updateEntireStepStatus(long jobInstanceId, String stepId, StepStatus newStepStatus) {
        this._persistenceManager.updateData(1, new StepStatusKey(jobInstanceId, stepId), newStepStatus);
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        String method = "init";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASSNAME, method);
        }
        ServicesManager sm = ServicesManagerImpl.getInstance();
        this._persistenceManager = sm.getPersistenceManagerService();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASSNAME, method);
        }
    }

    @Override
    public List<JobStatus> getAllJobStatus() throws BatchContainerServiceException {
        return null;
    }

    @Override
    public void updateJobStatusFromJSLStop(long jobInstanceId, String restartOn) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setRestartOn(restartOn);
        this.persistJobStatus(jobInstanceId, js);
    }
}

