/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.IJobIdManagementService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;

public class JobIdManagerImpl
implements IJobIdManagementService {
    private static final String CLASSNAME = JobIdManagerImpl.class.getName();
    protected String rootDir;
    private static final String JOBID_FILE_NAME = "jobId.dat";
    private static Logger logger = Logger.getLogger(JobIdManagerImpl.class.getPackage().getName());

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        this.rootDir = System.getProperty("user.home");
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    @Override
    public long getExecutionId() {
        return this.getId();
    }

    @Override
    public long getInstanceId() {
        return this.getId();
    }

    @Override
    public long getStepExecutionId() {
        return this.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getJobIdFromStorage() {
        StringBuilder contents = new StringBuilder("0");
        File jobIdFile = new File(this.rootDir + File.separator + JOBID_FILE_NAME);
        if (jobIdFile.exists()) {
            try {
                BufferedReader input = new BufferedReader(new FileReader(this.rootDir + File.separator + JOBID_FILE_NAME));
                try {
                    String line = null;
                    line = input.readLine();
                    if (line != null) {
                        contents.append(line);
                    }
                }
                finally {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return contents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveJobIdToStorage(long currentId) {
        File jobIdFile = new File(this.rootDir + File.separator + JOBID_FILE_NAME);
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(jobIdFile));
            try {
                output.write(String.valueOf(currentId));
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private long getId() {
        String id = this.getJobIdFromStorage();
        long jobId = Long.valueOf(id);
        this.saveJobIdToStorage(++jobId);
        return jobId;
    }
}

