/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.services.IPersistenceDataKey;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.services.impl.AbstractMapBasedPersistenceManagerImpl;
import com.ibm.jbatch.spi.services.IBatchConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.StepExecution;

public class FileBasedPersistenceManagerImpl
extends AbstractMapBasedPersistenceManagerImpl
implements IPersistenceManagerService {
    private static final String CLASSNAME = FileBasedPersistenceManagerImpl.class.getName();
    private static Logger logger = Logger.getLogger(FileBasedPersistenceManagerImpl.class.getPackage().getName());
    private static boolean _isInited = false;
    private static final String JOBSTATUSSTORE = "jobstatus.dat";
    private static final String STEPSTATUSSTORE = "stepstatus.dat";
    private static final String CHECKPOINTSTORE = "checkpoint.dat";

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        super.init(batchConfig);
        this._loadDataStores();
    }

    @Override
    protected void _loadDataStores() {
        Hashtable store = null;
        store = this._loadStore(0);
        if (store != null) {
            _jobStatusStore = store;
        } else {
            _jobStatusStore = new Hashtable();
            this._saveStore(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _saveStore(int storeId) {
        String path = this._getStorePath(storeId);
        try {
            FileOutputStream file = new FileOutputStream(new File(path));
            BufferedOutputStream buffer = new BufferedOutputStream(file);
            ObjectOutputStream output = new ObjectOutputStream(buffer);
            try {
                switch (storeId) {
                    case 0: {
                        output.writeObject(_jobStatusStore);
                        return;
                    }
                }
                return;
            }
            finally {
                output.close();
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Error saving Store:" + path, ex);
        }
    }

    protected String _getStorePath(int storeId) {
        String storeName = null;
        switch (storeId) {
            case 0: {
                storeName = JOBSTATUSSTORE;
                break;
            }
            case 1: {
                storeName = STEPSTATUSSTORE;
                break;
            }
            case 2: {
                storeName = CHECKPOINTSTORE;
                break;
            }
            default: {
                logger.severe("Invalid storeId! " + storeId);
            }
        }
        throw new UnsupportedOperationException("Needs implementation to decide what directory to host file store.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable _loadStore(int storeId) {
        String path = this._getStorePath(storeId);
        File jobStore = new File(path);
        Hashtable store = null;
        if (jobStore.exists()) {
            try {
                FileInputStream file = new FileInputStream(jobStore);
                BufferedInputStream buffer = new BufferedInputStream(file);
                ObjectInputStream input = new ObjectInputStream(buffer);
                try {
                    store = (Hashtable)input.readObject();
                }
                finally {
                    input.close();
                }
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.SEVERE, "Error loading store " + path + ". Class not found.", ex);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error loading store " + path, ex);
            }
        }
        return store;
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    @Override
    public void createData(int storeDestination, IPersistenceDataKey key, Serializable value) throws PersistenceException {
    }

    @Override
    public void deleteData(int storeDestination, IPersistenceDataKey key) throws PersistenceException {
    }

    @Override
    public List getData(int storeDestination, IPersistenceDataKey key) throws PersistenceException {
        return null;
    }

    @Override
    public void updateData(int storeDestination, IPersistenceDataKey key, Serializable value) throws PersistenceException {
    }

    @Override
    public int jobOperatorGetJobInstanceCount(String jobName) {
        return 0;
    }

    @Override
    public long jobOperatorQueryJobExecutionJobInstanceId(long executionID) {
        return 0L;
    }

    @Override
    public String jobOperatorQueryJobExecutionStatus(long executionID, String requestedStatus) {
        return null;
    }

    @Override
    public Timestamp jobOperatorQueryJobExecutionTimestamp(long executionID, String timetype) {
        return null;
    }

    @Override
    public List<Long> jobOperatorgetJobInstanceIds(String jobName, int start, int count) {
        return null;
    }

    @Override
    public Set<String> jobOperatorgetJobNames() {
        return null;
    }

    @Override
    public void jobExecutionStatusStringUpdate(long key, String statusToUpdate, String statusString, Timestamp updatets) {
    }

    @Override
    public void jobExecutionTimestampUpdate(long key, String timestampToUpdate, Timestamp ts) {
    }

    @Override
    public void jobOperatorCreateExecutionData(long key, Timestamp createTime, Timestamp starttime, Timestamp endtime, Timestamp updateTime, Properties parms, long instanceID, String batchstatus, String exitstatus) {
    }

    @Override
    public void jobOperatorCreateJobInstanceData(long key, String jobNameValue) {
    }

    @Override
    public void stepExecutionCreateStepExecutionData(String stepExecutionKey, long jobExecutionID, StepContextImpl stepContext) {
    }

    @Override
    public JobExecution jobOperatorGetJobExecution(long jobExecutionId) {
        return null;
    }

    @Override
    public void jobOperatorUpdateBatchStatusWithSTATUSandUPDATETSonly(long key, String statusToUpdate, String statusString, Timestamp updatets) {
    }

    @Override
    public void jobOperatorUpdateBatchStatusWithUPDATETSonly(long key, String statusToUpdate, String statusString, Timestamp updatets) {
    }

    @Override
    public List<JobExecution> jobOperatorGetJobExecutionsByJobInstanceID(long jobInstanceID) {
        return null;
    }

    @Override
    public List<JobExecution> jobOperatorGetJobExecutions(long jobInstanceId) {
        return null;
    }

    @Override
    public Set<Long> jobOperatorGetRunningExecutions(String jobName) {
        return null;
    }

    @Override
    public List<StepExecution> getStepExecutionIDListQueryByJobID(long execid) {
        return null;
    }

    @Override
    public StepExecution getStepExecutionObjQueryByStepID(long stepexecutionId) {
        return null;
    }

    @Override
    public Properties getParameters(long instanceId) {
        return null;
    }
}

